function xt = as_htensor(t)
%AS_HTENSOR Construct the htensor that represents t
%
%Remark, the ranks grow to (2*d-1)*k. Be carefull. They can however be
%significantly reduced by truncation (to very high accuracy).

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

% TODO add option for truncation and use truncate_sum

% Add every perturbation in t.dx_h to x;
for ii=1:t.x.nr_nodes
  temp = t.x;
  if t.x.is_leaf(ii)
    temp.U{ii} = t.dx_h.U{ii};
  else
    temp.B{ii} = t.dx_h.B{ii};
  end
  
  if ii==1
    xt = temp;
  else
    xt = xt + temp;
  end    
end

