function t = fill_rand(t)
%FILL_RAND Fill t with random entries

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

%% First fill with random entries
for ii=1:size(t.dx_h.children, 1)
  t.dx_h.U{ii} = rand(size(t.dx_h.U{ii}));
  t.dx_h.B{ii} = rand(size(t.dx_h.B{ii}));
end

%% Then make sure the U and B belong to horizonal space
isorth = t.x.is_orthog;

% all the leafs for U
for ii=1:size(t.x.children, 1)  
  if t.x.is_leaf(ii)
    Ut_h = t.dx_h.U{ii};
    Ut = t.x.U{ii};
    if isorth
      t.dx_h.U{ii} = Ut_h - Ut*(Ut'*Ut_h);
    else
      t.dx_h.U{ii} = Ut_h - Ut*((Ut'*Ut)\(Ut'*Ut_h));
    end
  end  
end

% all the inner nodes for B (except root and leafs)
for ii=2:size(t.x.children, 1)  
  if ~t.x.is_leaf(ii)
    sz = size(t.dx_h.B{ii}); 
    Bt_h = matricize(t.dx_h.B{ii},3)';
    Bt = matricize(t.x.B{ii},3)';
       
    if isorth
      T = Bt_h - Bt*(Bt'*Bt_h);   
    else
      Ut1 = t.x.U{t.x.children(ii,1)};
      Ut2 = t.x.U{t.x.children(ii,2)};
      M1 = Ut1'*Ut1;
      M2 = Ut2'*Ut2;      
      M = kron(M2,M1);
      T = Bt_h - Bt*((Bt'*M*Bt)\(Bt'*M*Bt_h));   % expensive! O(k^6)
    end
    t.dx_h.B{ii} = dematricize( T', sz, 3 );
  end
end

end