function t = minus(t1, t2)
%MINUS Binary subtraction for tangent

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

if( nargin~=2 )
  error('Two arguments required.');
end
% Check type of t1, t2
if( ~isa(t1, 'tangent') || ~isa(t2, 'tangent') )
  error('Both arguments must be of class tangent.');
end


t = t1;
for ii=1:t.x.nr_nodes
  if t.x.is_leaf(ii)
    t.dx_h.U{ii} = t1.dx_h.U{ii} - t2.dx_h.U{ii};
  else
    t.dx_h.B{ii} = t1.dx_h.B{ii} - t2.dx_h.B{ii};
  end
end