function n = norm(t)
%MINUS Binary subtraction for tangent

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.


% Compute the Frobenius norm of each entry
n = 0;
for ii=1:t.x.nr_nodes
  if t.x.is_leaf(ii)
    n = n + t.dx_h.U{ii}(:)'*t.dx_h.U{ii}(:);
  else
    n = n + t.dx_h.B{ii}(:)'*t.dx_h.B{ii}(:);
  end
end
n = sqrt(n);