classdef tangent
% TANGENT - Tangent vector for htensor

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.


  
  properties( SetAccess = public, GetAccess = public )
    
    x       % The htensor of this tangent vector
    dx_h    % The horizontal vector representing the tangent vector data
    
  end
  
  methods( Access = public )
    
    function t = tangent(varargin)
      %TANGENT Construct a tangent vector of an htensor
      %
      %   T = TANGENT(X) creates an empty tangent vector for the htensor x.
      
      if nargin==1 ||  nargin==3
        
        if(isa(varargin{1}, 'htensor'))          
          t.x = varargin{1};
          
          if nargin==1
            % make a zero htensor like x
            t.dx_h = t.x; % copy
            for ii=1:size(t.dx_h.children, 1)
              t.dx_h.U{ii} = zeros(size(t.dx_h.U{ii}));
              t.dx_h.B{ii} = zeros(size(t.dx_h.B{ii}));            
            end

            % Sanity check on dimensions and ranks
            if size(t.x.B{1},1) ~= size(t.x.B{1},2)
              error('A full rank tensor must have a at least a square x.B{1}')
            end
          else
            t.dx_h = htensor(t.x.children, t.x.dim2ind, varargin{2}, varargin{3}); % copy
%             for ii=1:size(t.dx_h.children, 1)
%               if t.x.is_leaf(ii)
%                 t.dx_h.U{ii} = varargin{2}{ii};
%               else
%                 t.dx_h.B{ii} = varargin{3}{ii};            
%               end
%             end

            % Sanity check on dimensions and ranks
            if size(t.x.B{1},1) ~= size(t.x.B{1},2)
              error('A full rank tensor must have a at least a square x.B{1}')
            end
          end
            
            
          % much TODO: check ranks
          
          
        else
          error('First argument needs to be a htensor object')
        end
        
      end
      
      
    end
    
    % Methods implemented in respective files    
    
    x_t = as_htensor(t);
    
    t = plus(t1, t2); 
    t = minus(t1, t2);
    n = norm(t);
    
    t = fill_rand(t);    
            
    
    % Totally not scalable methods O(n^d) or higher
    [T, X] = full(t);
  end
  
end