function [y,sizes] = htensor_to_param(x)
% Get the parameters from the htensor and vectorize them

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.


y = [];
sizes.children = x.children;
sizes.dim2ind = x.dim2ind;
sizes.nr_nodes = x.nr_nodes;

for ii=1:x.nr_nodes  
  U = x.U{ii};
  B = x.B{ii};
  sizes.U{ii} = size(U);
  sizes.B{ii} = size(B);  
  y = [y; U(:); B(:)];
end