function x = param_to_htensor(y, sizes)
% Make an htensor x based on vectorized parameters y

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

B = cell(1, sizes.nr_nodes);
U = cell(1, sizes.nr_nodes);

jj = 1;
for ii=1:sizes.nr_nodes
  sU = sizes.U{ii};
  if sU(1)>0
    %[nu,ku] = sU;
    U{ii} = reshape(y(jj:jj+sU(1)*sU(2)-1), sU(1), sU(2));
    jj = jj+sU(1)*sU(2);
  end
  
  sB = sizes.B{ii};
  if sB(1)>0
    if length(sB) == 2
      %[k1,k2] = sB;
      B{ii} = reshape(y(jj:jj+sB(1)*sB(2)-1), sB(1), sB(2));
      jj = jj+sB(1)*sB(2);
    else      
      %[k1,k2,k12] = sB;
      B{ii}  = reshape(y(jj:jj+sB(1)*sB(2)*sB(3)-1), sB(1), sB(2), sB(3));
      jj = jj+sB(1)*sB(2)*sB(3);
    end
  end
end

x = htensor(sizes.children, sizes.dim2ind, U,B);