function t = param_to_tang(x,y)
% Make a tangent vector of x based on vectorized parameters y

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

dB = cell(1, x.nr_nodes);
dU = cell(1, x.nr_nodes);

jj = 1;
for ii=1:x.nr_nodes
  if size(x.U{ii},1)>0
    [nu,ku] = size(x.U{ii});
    dU{ii} = reshape(y(jj:jj+nu*ku-1), nu, ku);
    jj = jj+nu*ku;
  end
  if size(x.B{ii},1)>0
    if length(size(x.B{ii})) == 2
      [k1,k2] = size(x.B{ii});
      dB{ii} = reshape(y(jj:jj+k1*k2-1), k1, k2);
      jj = jj+k1*k2;
    else      
      [k1,k2,k12] = size(x.B{ii});
      dB{ii}  = reshape(y(jj:jj+k1*k2*k12-1), k1, k2, k12);
      jj = jj+k1*k2*k12;
    end
  end
end
t = tangent(x,dU,dB);