function Ut = extract_inner_all_U_as_full(x)
% Extract the all frames U_node of x belonging to an all nodes.
%
% The frames are represented as a full tensors of size n_t x k_t;

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.


Ut = x.U; % we will overwrite x.U

x_is_leaf = x.is_leaf;

% Loop through all nodes, starting with the leaf nodes.
for ii=x.nr_nodes:-1:1
   
  if(x_is_leaf(ii))
    % Matrix U already known
    continue;
  else
    % Find child nodes
    ii_left  = x.children(ii, 1);
    ii_right = x.children(ii, 2);

    BUU = ttm(x.B{ii}, {Ut{ii_left}, Ut{ii_right}}, [1 2]);
    Ut{ii} = matricize(BUU, [1 2], 3, false);
    
    % Clear variables to save memory
    clear BUU;    
  end 

end