function t = project_onto_Tspace_full(x,dX)
% Project dX onto the tangent space of x.
% Uses full tensor for dX => slow; see project_onto_Tspace_full2 for faster
% implementation.

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

t = tangent(x);

% initialize cells of matrices U and B, and dU and dB:
U = cell(1, x.nr_nodes);
dU = cell(1, x.nr_nodes);
dB = cell(1, x.nr_nodes);


x_is_leaf = x.is_leaf;
x_dims = x.dims;

%%% First, build up all the U (on all levels)
x_lvl = x.lvl;
% Go through all levels from leafs to root node
for lvl_iter = max(x_lvl):-1:0
  % Go through all nodes at given level
  for ii=find(x_lvl == lvl_iter)
    
    % Leafs: take over U
    if x_is_leaf(ii)
      U{ii} = x.U{ii};
      
    else % Inner nodes and root: compute U
      ii_left  = x.children(ii, 1);
      ii_right = x.children(ii, 2);
      U{ii} = kron(U{ii_right}, U{ii_left})*matricize(x.B{ii},[1 2]);
    end
        
  end
  
end



%%% Next, compute recursively the projection for dx_h

% root node is known by definition
dU{1} = matricize(dX, x_dims{1}); 

% traverse tree from root to leafs
for ii=1:x.nr_nodes
  
  if x_is_leaf(ii)
    t.dx_h.U{ii} = dU{ii};
    continue;
  end
  
  ii_left  = x.children(ii, 1);
  ii_right = x.children(ii, 2);

  % Number of rows of child node matrices
  n_left = size(U{ii_left}, 1);
  n_right = size(U{ii_right}, 1);
  
  % reshape U{ii} to a k(ii) x n_left x n_right tensor
  if ii==1
    k(ii) = 1;
  else
    k(ii) = size(U{ii},2);
  end
  U_tensor = dematricize(dU{ii}, [n_left, n_right, k(ii)], ...
    [1 2], 3, false);

  % Apply matrices U{ii_left} and U{ii_right} to find
  % transfer tensor dB{ii}
  if x.is_orthog
    Uii_l = U{ii_left};
    Uii_r = U{ii_right};
  else
    M1 = U{ii_left}'*U{ii_left};
    M2 = U{ii_right}'*U{ii_right}; 
    M = kron(M2,M1);
    Uii_l = U{ii_left}/M1;
    Uii_r = U{ii_right}/M2;
  end
  dB{ii} = ttm(U_tensor, {Uii_l, Uii_r}, [1 2], 'h');
  
  % Project out non orth part for all the leafs except the root 
  if ii~=1
    B3 = matricize(x.B{ii},3)';
    dB3 = matricize(dB{ii},3)';
    if x.is_orthog
      dB3 = dB3 - B3*((B3'*B3)\(B3'*dB3));
    else      
      dB3 = dB3 - B3*((B3'*M*B3)\(B3'*M*dB3));
    end
    dB{ii} = dematricize(dB3', size(dB{ii}), [3]);
  end
  t.dx_h.B{ii} = dB{ii};  
  
  
  % Calculate the next dUs      
  TT = ttm(U_tensor, Uii_r, 2, 'h');
  TT = TT - ttm(dB{ii}, U{ii_left}, 1);
  dU{ii_left} = matricize(TT, 1)*pinv(matricize(x.B{ii},1));
    
  TT = ttm(U_tensor, Uii_l, 1, 'h');
  TT = TT - ttm(dB{ii}, U{ii_right}, 2);
  dU{ii_right} = matricize(TT, 2)*pinv(matricize(x.B{ii},2));
  
end

    