function t = project_onto_Tspace_full2(x,dX)
% Project dX onto the tangent space of x.
% Uses full tensor for dX => slow

% Same as project_onto_Tspace_full except that extract_inner_all_U is used.
% This is much faster for larger (N>30) tensors.

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.


% initialize cells of matrices U and B, and dU and dB:
dU = cell(1, x.nr_nodes);
dB = cell(1, x.nr_nodes);

x_is_leaf = x.is_leaf;
x_dims = x.dims;

%%% First, build up all the U (on all levels)
U = extract_inner_all_U_as_full(x);

%%% Next, compute recursively the projection for dx_h
% root node is known by definition
dU{1} = matricize(dX, x_dims{1}); 

% traverse tree from root to leafs: TODO
for ii=1:x.nr_nodes
  
  if x_is_leaf(ii)
    continue;
  end
  
  ii_left  = x.children(ii, 1);
  ii_right = x.children(ii, 2);
  
  n_left = size(U{ii_left}, 1);
  n_right = size(U{ii_right}, 1);
  
  % reshape U{ii} to a k(ii) x n_left x n_right tensor
  if ii==1
    kk = 1;
  else
    kk = size(U{ii},2);
  end
  U_tensor = dematricize(dU{ii}, [n_left, n_right, kk], [1 2], 3, false);
  
  % Apply matrices U{ii_left} and U{ii_right} to find
  % transfer tensor dB{ii}    
  if x.is_orthog
    Uii_l = U{ii_left};
    Uii_r = U{ii_right};
  else
    M1 = U{ii_left}'*U{ii_left};
    M2 = U{ii_right}'*U{ii_right}; 
    M = kron(M2,M1);
    Uii_l = U{ii_left}/M1;
    Uii_r = U{ii_right}/M2;
  end
  TT = ttm(U_tensor, Uii_r, 2, 'h'); % we need this later
  dB{ii} = ttm(TT, Uii_l, 1, 'h'); % orthogonalize below since we need intermediate dB
      
  % Calculate the next dUs      
  TT = TT - ttm(dB{ii}, U{ii_left}, 1);
  dU{ii_left} = matricize(TT, 1)*pinv(matricize(x.B{ii},1));
  
  TT = ttm(U_tensor, Uii_l, 1, 'h');
  TT = TT - ttm(dB{ii}, U{ii_right}, 2);
  dU{ii_right} = matricize(TT, 2)*pinv(matricize(x.B{ii},2));
  
  
  % Project out non orth part for all the leafs except the root 
  if ii~=1
    B3 = matricize(x.B{ii},3)';
    dB3 = matricize(dB{ii},3)';
    if x.is_orthog
      dB3 = dB3 - B3*((B3'*B3)\(B3'*dB3));
    else      
      dB3 = dB3 - B3*((B3'*M*B3)\(B3'*M*dB3));
    end
    dB{ii} = dematricize(dB3', size(dB{ii}), 3);
  end
    
  
  % We are done with the current ii
  dU{ii} = []; U{ii} = []; 
end


t = tangent(x,dU,dB);
    