function plot_influence_epsilon()
% Plot Figures 1 and 2 of the paper "The geometry of algorithms using 
% hierarchical tensors" by A. Uschmajew and B. Vandereycken.

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.

rand('state',0); randn('state',0);

N = 25;
dim = 4;
rank = 3;
Tend = 15;
cte = 0;
%cte = 2;


sz = ones(1,dim)*N;
x = htenrandn(sz);
hk = ones(x.nr_nodes, 1)*rank;
hk(1) = 1;
hk(2) = hk(3);


[ts, err_dyn, err_svd] = do_calc_integrate(x, sz, hk, 1e-7, cte, Tend);
semilogy(ts, err_dyn, 'b-')
hold all
semilogy(ts, err_svd, 'bo')

[ts, err_dyn, err_svd] = do_calc_integrate(x, sz, hk, 1e-4, cte, Tend);
semilogy(ts, err_dyn, 'r-')
hold all
semilogy(ts, err_svd, 'ro')

[ts, err_dyn, err_svd] = do_calc_integrate(x, sz, hk, 1e-1, cte, Tend);
semilogy(ts, err_dyn, 'k-')
hold all
semilogy(ts, err_svd, 'ko')

xlabel('s')
ylabel('absolute error')


end


