function test_tangent()
%TEST_TANGENT
% Compute the distance of a tangent vector to the manifold.
% Since best approx is not possible, we do truncated SVDs.
% They have a quasi-optimality: We know from theory that
%
% ||X - X_best|| <= ||X - X_|| <= err_bd <= factor*||X - X_best||
%
% and max(err) <= ||X - X_best||, therefore
%
% max(err_bd/factor, max(err)) <= ||X - X_best|| <= ||X - X_|| <= err_bd
%
% give upper and lower bounds for the best approximation as well
% as the truncated version constructed here.

% Geometric Hierchical Tucker 
% Copyright 2012 Bart Vandereycken, EPF Lausanne
% GPLv3 License, see COPYING.txt for details.


rand('state',0); randn('state',0);

x = htenrandn([4 5 6 7], 'orthog', [1 3 3 2 3 3 5]);

x = orthog(x);
x.B
h_k = get_h_ranks(x);


t = tangent(x);
t = fill_rand(t);

X = full(x);
X = X/norm(X(:));

T = full(t);
T = T/norm(T(:));
N = rand(size(X));
N = N/norm(N(:));




ep = logspace(-15,-1,100);

[diff_upper,diff_lower] = calc_dist(x, T, ep);
loglog(ep,diff_upper, 'b--')
hold all
loglog(ep,diff_lower, 'b-')


[diff_upper,diff_lower] = calc_dist(x, N, ep);
loglog(ep,diff_upper, 'r--')
hold all
loglog(ep,diff_lower, 'r-')

loglog(ep(end-20:end), 1e-1* ep(end-20:end).^2, 'k-')
loglog(ep(end-40:end), 1e-1* ep(end-40:end).^1, 'k--')

end

function [up,low] = calc_dist(x, T, ep)

X = full(x);
opts.max_rank = 0;
opts.abs_eps = 0;
opts.h_ranks = get_h_ranks(x);
opts.children = x.children;
opts.dim2ind = x.dim2ind;
 
for ii=1:length(ep)
  Xt = X + ep(ii)*T;

  [xt_k, err, sv] = htensor.truncate_ltr(Xt, opts);
  %[xt_k, err, sv] = htensor.truncate_rtl(Xt, opts);
  Xt_k = full(xt_k);
  
  % Count top-level truncation only once
  err_ = err; err_(xt_k.children(1, 1)) = 0;  
  % Calculate upper bound and factor c from ||x - x_|| <= c ||x - x_best||
  err_bd = norm(err_); factor = sqrt(2*ndims(xt_k)-3);
  low(ii) = max(err_bd/factor, max(err));
  up(ii) = norm(Xt_k(:) - Xt(:),2);  % upper bound distance
end
end

