% -------------------------------
% Block maxima method   (BMM)
% -------------------------------
% Gilli and Kellezi, 01-05-2005
%
%hold off, close all, clear all
rand('seed',987654321); fprintf('\n    ==> Seed set !!!!!!\n\n');

FS = 20;
Dset = str2mat('EuroXX','FTS','HS','Nikkei','SMI','SP','P');
for i = 1:size(Dset,1)
    fprintf(' %i  %s\n',i,Dset(i,:));
end
k = input('Give index for Dateset --> ');
load c:/projects/evtrm/CSDA2004/CSDA_data_c
eval(['r   = ',deblank(Dset(k,:)),'_ret;']);
eval(['dat = ',deblank(Dset(k,:)),'_dat;']);
n = length(r);
figure(1)
subplot(211), plot(dat,r,'k'), dateaxis('x',12), axis([dat(1) dat(n) -15 15])
n = length(dat);
%    n = datenum('31-Dec-1989');
%    n = length(find(dat<=n));
disp([' ',deblank(Dset(k,:)),' (',datestr(dat(1)),' to ',datestr(dat(n)),')'])
r = -r(1:n);   %--- We change the sign to make losses positiv ---
dat = dat(1:n);
% Compute yearly block maxima (minima) and associate dates (M and Mdat)

y = year(dat);
d = diff([min(y)-1 y' max(y)+1]);
c = find(d~=0);
noby = diff(c);           % Number of observations per year
nyears = length(noby);
M = repmat(NaN,nyears,1);
for i = 1:nyears
   [M(i), j] = max(r( c(i):c(i+1)-1 ));
   Mdat(i)   = dat(j + c(i) - 1);  % Dates where Maxima occur
   [m(i), j] = min(r( c(i):c(i+1)-1 ));
   mdat(i)   = dat(j + c(i) - 1);  % Dates where Minima occur
end
fprintf('   %3i observations\n',nyears);

figure(2)   % Block_maxima.eps
subplot(211), h1=bar(Mdat,-M,.7); axis([dat(1)-50 dat(n)+150 -30 15]); dateaxis('x')
set(h1,'FaceColor','r'); hold on      
h2=bar(mdat,-m,.7); plot([dat(1) dat(length(dat))],[0 0],'k')
set(h2,'FaceColor','g'); set(gca,'FontSize',12)

LeftTail = 1;
if LeftTail
    fprintf('\n *** Left Tail ***\n');
else
    M = -m; fprintf('\n *** Right Tail ***\n');
end

% ML estimation of GEV

phat  = [.3 2 1];  % Initial values for estimation
phat  = fminsearch('gevlike',phat,[],M);
xi    = phat(1);
mu    = phat(2);
sigma = phat(3);

figure(3)
alpha = .05;  % <-- Level for confidence interval
crit = -.5*chi2inv(1-alpha,1);   % 1 degree of freedom
xswindow = [0.05 0.75 0.8 2];   % window for xi sigma plot (optional argument)

[ci_xi, ci_sigma] = GEV_PLci0(xi,sigma,mu,M,[alpha alpha],xswindow);

fprintf('\n ML estimates and confidence intervals (%2i%%) of GEV',fix(100*(1-alpha)));
fprintf('\n\n        lower bound   point estimate   upper bound');
fprintf('\n     xi  %6.3f         %7.3f         %6.3f',ci_xi(1,1),   xi,   ci_xi(1,2));
fprintf('\n  sigma  %6.3f         %7.3f         %6.3f',ci_sigma(1,1),sigma,ci_sigma(1,2));

% Direct ML estimation of Rnk

k = 10; 
phat(3) = mu - sigma/xi*(1-(-log(1-1/k))^(-xi)); % Initial value for Rnk estimation
const = k;
a = ones(1,3);
phat = fminsearch('gevqlike',phat,[],const,a,M);
xi    = phat(1);
sigma = phat(2);
Rnk   = phat(3);

% Display empirical and estimated distribution function

Fn   = ((1:nyears))/nyears;
Msrt = sort(M);
xx = linspace(min(M),3*max(M));
yy = gevqcdf(xx,xi,sigma,Rnk,k);

figure(4)     % fitted_GEV
plot(Msrt,Fn,'LineStyle','none','Marker','.','MarkerSize',12,'Color','k'), hold on
plot(xx,yy,'k'), axis([0 25 0 1.1]), grid
set(gca,'FontSize',20)

% Construct likelihood based confidence intervals
p_ci     = 0.05;
xihat    = xi;
sigmahat = sigma;
Rnkhat   = Rnk;
Lhat = -gevqlike([xihat sigmahat Rnkhat],k,[1 1 1],M); % logl

crit = -.5*chi2inv(1-p_ci,1);
Rnkci = PL_ci_Rnk(Rnkhat,Lhat,k,xihat,sigmahat,M,crit); % Conf. int. for Rnk
fprintf('\n   R^10  %6.3f         %7.3f         %6.3f  \n',Rnkci(1),Rnk,Rnkci(2));

% Compute the relative profile Lstar - Lhat for Rnk

Rnkpoints = 200;
Rnki = linspace(4,14,Rnkpoints); %linspace(0.9*Rnkci(1),1.2*Rnkci(2),Rnkpoints);
Lprof = zeros(Rnkpoints,1);
h = waitbar(0,' Computing profile ...');
for i = 1:Rnkpoints
   const = [Rnki(i) k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof(i) = Lstar - Lhat;
   waitbar(i/Rnkpoints,h)
end,  close(h);
ndi = 2;
figure(5) % GEV-R10-ci
plot(Rnki,Lprof,'r','LineWidth',2); hold on
plot([.8*Rnkci(1) 1.4*Rnkci(2)],[crit crit],'-.')
plot(Rnkci,[crit crit],'LineStyle','none','Marker','o','MarkerSize',12,'Color','k')
plot(Rnkhat,0,'LineStyle','none','Marker','*','MarkerSize',15,'Color','k')
set(gca,'xtick',TickVals([Rnkci(1) Rnkhat Rnkci(2)],ndi));
set(gca,'ytick',TickVals([crit 0],ndi));
xlabel('R^1^0','FontSize',20);
axis([4 14 -7 .5]), grid
set(gca,'FontSize',20)

% Compute the relative profile Lstar - Lhat for contours Rnk and xi

maxit = 200;
options = optimset('fminsearch');
options = optimset('MaxIter',maxit);
xipoints = 100;
xii = linspace(-0.1,1.5,xipoints);
Rnkpoints = 100;
Rnki = linspace(4,17,Rnkpoints);
L = zeros(xipoints,Rnkpoints);
pp = L;
phat0 = sigmahat;
h = waitbar(0,' Computing surface ...');
for i = 1:xipoints 
   for j = 1:Rnkpoints
      a = [0 1 0];
      const = [xii(i) Rnki(j) k];      
      [phat1,F,flag,output] = fminsearch('gevqlike',phat0,options,const,a,M);
      if output.iterations < maxit
         L(i,j) = -gevqlike(phat1,const,a,M); %logl
         pp(i,j) = phat1;
         phat0 = phat1;
      else
         L(i,j) = NaN;
         pp(i,j) = phat1;
         phat0 = sigmahat;
      end
   end
   waitbar(i/xipoints,h)
end, close(h)
Lprof2 = L - Lhat;

figure(6)
%mesh(Rnki,xii,Lprof2)
surfl(Rnki,xii,Lprof2); hold on
shading interp; colormap(hot);

figure(7) % GEV_xi_Rnk_ci.eps
crit = -.5*chi2inv(.95,2);
contour(Rnki,xii,Lprof2,[crit crit],'r','LineWidth',2), hold on
axis([3 16 -.1 1.5])
xlabel('R^1^0','FontSize',20)
ylabel('\xi','Rotation',0,'FontSize',20)
plot(Rnkhat,xihat,'LineStyle','none','Marker','*','MarkerSize',15,'Color','k');
plot([Rnkci(1) Rnkci(1) Rnkci(2) Rnkci(2) Rnkci(1)], ...
[ci_xi(1,1) ci_xi(1,2) ci_xi(1,2) ci_xi(1,1) ci_xi(1,1)],'r','LineWidth',2);
set(gca,'xtick',TickVals([Rnkci(1) Rnkhat Rnkci(2)],ndi));
set(gca,'ytick',TickVals([ci_xi(1,1)  xihat ci_xi(1,2)],ndi));
set(gca,'FontSize',20)

R = 1000;
BS = zeros(R,4);
k = 10;
pinit = [0.79  2.02  0.82];
pinit = fminsearch('gevlike',pinit,[],M);
h = waitbar(0,' Bootstrapping ...');
for i = 1:R
   ind = unidrnd(nyears,1,nyears);
   MM = M(ind);
   param = fminsearch('gevlike',pinit,[],MM);
   BS(i,1:3) = param;
   xi    = param(1); 
   mu    = param(2);
   sigma = param(3);
   BS(i,4) = mu - sigma/xi*(1-(-log(1-1/k))^(-xi));
   waitbar(i/R,h)
end,  close(h)

% Bootstrap Rnk and xi statistics
ML = BS(:,[4 1]);
BstrpIntV3('gevqlike',ML,Rnkhat,xihat,sigmahat,k,M,alpha);
axis([0.99*min(ML(:,1)) 1.01*max(ML(:,1)) 0.99*min(ML(:,2)) 1.01*max(ML(:,2))]);

