function   BstrpInt(Bstat,p1,p2,xtail,u,alpha)
% Crude bootstrap intervalls
ndi = 3; FS = 16;
B = size(Bstat,1);
sp1 = sort(Bstat(:,1)); sp2 = sort(Bstat(:,2));
p1inf = sp1(fix(.025*B));  p1sup = sp1(fix(.975*B));
p2inf = sp2(fix(.025*B));  p2sup = sp2(fix(.975*B));

ofms = optimset('fminsearch');
ofms = optimset(ofms,'MaxIter',200,'Display','none');
% Bias correction
z0p1 = norminv( sum(Bstat(:,1) < p1)/B,0,1);
z0p2 = norminv( sum(Bstat(:,2) < p2)/B,0,1);
% Computing the acceleration
N = length(xtail);
S1p1 = 0; S2p1 = 0; S1p2 = 0; S2p2 = 0;
phat = [p1 p2];
% Do the jacknife
for i = 1:N
    phat  = fminsearch('GPDlogLvec',phat,ofms,xtail([1:i-1 i+1:N]),u);
    p1d = p1 - phat(1);
    p2d = p2 - phat(2);
    S1p1 = S1p1 + p1d^3;
    S2p1 = S2p1 + p1d^2;
    S1p2 = S1p2 + p2d^3;
    S2p2 = S2p2 + p2d^2;
end
accp1 = S1p1 / (6*S2p1^(3/2));
accp2 = S1p2 / (6*S2p2^(3/2));

za  = norminv(  alpha,0,1);
z1a = norminv(1-alpha,0,1);
temp = z0p1 + (z0p1 + za)  / (1 - accp1*(z0p1 + za));
a1p1 = normcdf(temp,0,1);
temp = z0p1 + (z0p1 + z1a) / (1 - accp1*(z0p1 + z1a));
a2p1 = normcdf(temp,0,1);
temp = z0p2 + (z0p2 + za)  / (1 - accp2*(z0p2 + za));
a1p2 = normcdf(temp,0,1);
temp = z0p2 + (z0p2 + z1a) / (1 - accp2*(z0p2 + z1a));
a2p2 = normcdf(temp,0,1);

BCacp1inf = sp1(fix(a1p1*B));  BCacp1sup = sp1(fix(a2p1*B));
BCacp2inf = sp2(fix(a1p2*B));  BCacp2sup = sp2(fix(a2p2*B));

% BCa bootstrap intervalls
plot([BCacp1inf BCacp1inf],[BCacp2inf BCacp2sup],'b--','LineWidth',2)
plot([BCacp1sup BCacp1sup],[BCacp2inf BCacp2sup],'b--','LineWidth',2)
plot([BCacp1inf BCacp1sup],[BCacp2inf BCacp2inf],'b--','LineWidth',2)
plot([BCacp1inf BCacp1sup],[BCacp2sup BCacp2sup],'b--','LineWidth',2)

% Plot the bootstrap replicates
for i = 1:B
    plot(Bstat(i,1),Bstat(i,2),'LineStyle','none','Marker','.',...
        'MarkerSize',8,'Color','k');
end
ph = plot([0 1],[0 0],'r-',[0 1],[0 0],'b--','LineWidth',2);
legend(ph,'ML','BCa')
set(gca,'Xtick',TickVals([BCacp1inf p1 BCacp1sup],ndi),'FontSize',FS)
set(gca,'Ytick',TickVals([BCacp2inf p2 BCacp2sup],ndi),'FontSize',FS)
grid on
fprintf('\n        BCa: (%5.3f <       < %4.3f)',BCacp1inf,BCacp1sup);
fprintf('  (%4.3f <       < %4.3f)',BCacp2inf,BCacp2sup);
