function [ci_xi, ci_sigma] = GEV_PLci0(xi,sigma,mu,x,alpha,xswindow)

% Construct single confidence intervals (alpha MUST be increasing !!)
if length(alpha)>2, error('GEV_plci0: At most 2 elements in alpha !!'); end

k = 0;
for cl = alpha
   k = k + 1;
   ci_xi(k,:)    = GEV_plci1(xi,sigma,mu,x,cl,1);
   ci_sigma(k,:) = GEV_plci1(xi,sigma,mu,x,cl,2);
end

xi_grid    = 100;
sigma_grid = 100;
cLLH = zeros(xi_grid,sigma_grid);
if nargin == 5
   inf_xi_grid = ci_xi(1,1) - 0.5;
   sup_xi_grid = 1.5 * ci_xi(1,2);
   inf_sigma_grid = 0.5 * ci_sigma(1,1);
   sup_sigma_grid = 1.5 * ci_sigma(1,2);
else
   inf_xi_grid    = xswindow(1);
   sup_xi_grid    = xswindow(2);
   inf_sigma_grid = xswindow(3);
   sup_sigma_grid = xswindow(4);
end

xxi    = linspace(inf_xi_grid   ,sup_xi_grid   ,xi_grid);
ssigma = linspace(inf_sigma_grid,sup_sigma_grid,sigma_grid);

[X S] = meshgrid(xxi,ssigma);
h = waitbar(0,' Computing log-likelihood surface ...');
for i=1:xi_grid
   for j=1:sigma_grid
      cLLH(i,j) = GEVlike([xxi(i),mu,ssigma(j)],x);
   end
   waitbar(i/xi_grid,h)
end, close(h);

%mesh(X,S,cLLH)
surfl(X,S,cLLH); hold on
shading interp; colormap(hot);

ucLLH = GEVlike([xi,mu,sigma],x);    % unconstrained Log Likelihood
k = 0;
for cl = alpha
   k = k + 1;
   for df = 1:2
      chi     = chi2inv(1-cl,df);
      C(k,df) = ucLLH - chi/2;
   end
end

figure(3)
contour(X,S,cLLH',C(:,2),'r'), hold on
%contour(X,S,cLLH',[C(1,2) C(1,2)]), hold on
%legend(['alpha = ',num2str(alpha(1))],['alpha = ',num2str(alpha(2))]);
%save contplotdat X S cLLH C

plot([xi],[sigma],'+r')
xlabel('\xi')
ylabel('\sigma','Rotation',0)
%title(['Simultaneous and single confidence intervals (Profiled Likelihood) for u > ',num2str(mu)]);
   
plot(ci_xi(1,:),[ci_sigma(1,1) ci_sigma(1,1)],'r',ci_xi(1,:),[ci_sigma(1,2) ci_sigma(1,2)],'r');
plot([ci_xi(1,1) ci_xi(1,1)],ci_sigma(1,:),'r',[ci_xi(1,2) ci_xi(1,2)],ci_sigma(1,:),'r');

%plot(ci_xi(2,:),[ci_sigma(2,1) ci_sigma(2,1)],'g',ci_xi(2,:),[ci_sigma(2,2) ci_sigma(2,2)],'g');
%plot([ci_xi(2,1) ci_xi(2,1)],ci_sigma(2,:),'g',[ci_xi(2,2) ci_xi(2,2)],ci_sigma(2,:),'g');


%subplot(222)
%contour(X,S,cLLH',C(:,2)), hold on
%legend(['alpha = ',num2str(alpha(1))],['alpha = ',num2str(alpha(2))]);

%plot([xi],[sigma],'+r')
%grid
%xlabel('xi'), ylabel('sigma')
%title(['Simultaneous and single confidence intervals (Profiled Likelihood) for u > ',num2str(mu)]);
%figure(gcf)
   
%plot(ci_xi(1,:),[ci_sigma(1,1) ci_sigma(1,1)],'r',ci_xi(1,:),[ci_sigma(1,2) ci_sigma(1,2)],'r');
%plot([ci_xi(1,1) ci_xi(1,1)],ci_sigma(1,:),'r',[ci_xi(1,2) ci_xi(1,2)],ci_sigma(1,:),'r');
