function zero = GEV_plci1(xi,sigma,mu,x,alpha,ipar)
%
% Profiled likelihood single confidence interval at level alpha
% for the GPD parameter in position ipar (1 or 2).
%
maxit = 30; delta = 1e-5;   % Parameters for the bisection method
%
ucLLH = -GEVlike([xi,mu,sigma],x);    % unconstrained Log Likelihood
C = ucLLH - chi2inv(1-alpha,1)/2;
%
if ipar == 1          % Interval for xi
% -------------------------------------
% Recherche du zero a gauche du maximum
% -------------------------------------
% Chercher un point a gauche de xi pour lequel la fonction est negative
a = -.1;  % Previously a = 0.001;
b = xi;
if ~( (-GEVlike([a,mu,sigma],x) - C) < 0 ), keyboard,error('Problem in GEV_PLCI1'); end

it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = -GEVlike([c,mu,sigma],x) - C;
   fa = -GEVlike([a,mu,sigma],x) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in GEV_plci1'); end
end
zero(1) = mean([a b]); 
%
% -------------------------------------
% Recherche du zero a droite du maximum
% -------------------------------------
% definir point a droite de xi pour lequel la fonction est negative
fpos = 1;
step = .1*xi;
a = xi;
b = xi;
while fpos
   b = b + step;
   fpos = ( (-GEVlike([b,mu,sigma],x) - C) > 0 );
   step = 2*step;
end

it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = -GEVlike([c,mu,sigma],x) - C;
   fa = -GEVlike([a,mu,sigma],x) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in GEV_plci1'); end
end
zero(2) = mean([a b]); 

elseif ipar == 2   % Interval for sigma
% -------------------------------------
% Recherche du zero a gauche du maximum
% -------------------------------------
% Chercher un point a gauche de sigma pour lequel la fonction est negative
a = 0.001;
b = sigma;
if ~( (-GEVlike([xi,mu,a],x) - C) < 0 ), error('Problem in GPD_PLCI1'); end
it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = -GEVlike([xi,mu,c],x) - C;
   fa = -GEVlike([xi,mu,a],x) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in GEV_plci1'); end
end
zero(1) = mean([a b]); 
%
% -------------------------------------
% Recherche du zero a droite du maximum
% -------------------------------------
% Chercher un point a droite de xi pour lequel la fonction est negative
fpos = 1;
step = .1*sigma;
a = sigma;
while fpos
   b = b + step;
   fpos = ( (-GEVlike([xi,mu,b],x) - C) > 0 );
   step = 2*step;
end

it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = -GEVlike([xi,mu,c],x) - C;
   fa = -GEVlike([xi,mu,a],x) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in GEV_plci1'); end
end
zero(2) = mean([a b]); 

else
end
