function [ci_xi, ci_sigma] = GPD_PLci0(xi,sigma,mu,x,alpha,xswindow)

% Construct single confidence intervals (alpha MUST be increasing !!)
if length(alpha)>2, error('gpd_plci0: At most 2 elements in alpha !!'); end
FS = 18;
k = 0;
for cl = alpha
   k = k + 1;
   ci_xi(k,:)    = GPD_PLci1(xi,sigma,mu,x,cl,1);
   ci_sigma(k,:) = GPD_PLci1(xi,sigma,mu,x,cl,2);
end

xi_grid    = 100;
sigma_grid = 100;
cLLH = repmat(NaN,xi_grid,sigma_grid);
if nargin == 5
   inf_xi_grid = ci_xi(1,1) - 0.5;
   sup_xi_grid = 1.5 * ci_xi(1,2);
   inf_sigma_grid = 0.5 * ci_sigma(1,1);
   sup_sigma_grid = 1.5 * ci_sigma(1,2);
else
   inf_xi_grid    = xswindow(1);
   sup_xi_grid    = xswindow(2);
   inf_sigma_grid = xswindow(3);
   sup_sigma_grid = xswindow(4);
end

xxi    = linspace(inf_xi_grid   ,sup_xi_grid   ,xi_grid);
ssigma = linspace(inf_sigma_grid,sup_sigma_grid,sigma_grid);

[X S] = meshgrid(xxi,ssigma);
h = waitbar(0,' Computing log-likelihood surface ...');
for i=1:xi_grid
   for j=1:sigma_grid
      cLLH(i,j) = GPDlogLsca(x,xxi(i),ssigma(j),mu);
   end
   waitbar(i/xi_grid,h)
end, close(h);

mesh(X,S,cLLH)
ucLLH = GPDlogLsca(x,xi,sigma,mu);    % unconstrained Log Likelihood
k = 0;
for cl = alpha
   k = k + 1;
   for df = 1:2
      chi     = chi2inv(1-cl,df);
      C(k,df) = ucLLH - chi/2;
   end
end

contour(X,S,cLLH',C(:,2),'r','LineWidth',1.5), hold on
plot([xi],[sigma],'*r','MarkerSize',15)
xlabel('\xi','Fontsize',FS)
ylabel('\sigma','Rotation',0,'Fontsize',FS)
%title(['Simultaneous and single confidence intervals (Profiled Likelihood) for u > ',num2str(mu)]);
   
plot(ci_xi(1,:),[ci_sigma(1,1) ci_sigma(1,1)],'r',ci_xi(1,:),[ci_sigma(1,2) ci_sigma(1,2)],'r','LineWidth',1.5);
plot([ci_xi(1,1) ci_xi(1,1)],ci_sigma(1,:),'r',[ci_xi(1,2) ci_xi(1,2)],ci_sigma(1,:),'r','LineWidth',1.5);

