function zero = gpd_plci1(xi,sigma,mu,x,alpha,ipar)
%
% Profiled likelihood single confidence interval at level alpha
% for the GPD parameter in position ipar (1 or 2).
%
maxit = 30; delta = 1e-5;   % Parameters for the bisection method
%
ucLLH = GPDlogLsca(x,xi,sigma,mu);    % unconstrained Log Likelihood
C = ucLLH - chi2inv(1-alpha,1)/2;
%
if ipar == 1          % Interval for xi
% -------------------------------------
% Recherche du zero a gauche du maximum
% -------------------------------------
% Chercher un point a gauche de xi pour lequel la fonction est negative
a = -0.1; % a = 0.001; 
b = xi;
if ~( (GPDlogLsca(x,xi,a,mu) - C) < 0 ) 
    disp('Choose appropriate value for a in GPD_PLCI1');
    keyboard
end

it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = GPDlogLsca(x,c,sigma,mu) - C;
   fa = GPDlogLsca(x,a,sigma,mu) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in gpd_plci1'); end
end
zero(1) = mean([a b]); 
%
% -------------------------------------
% Recherche du zero a droite du maximum
% -------------------------------------
% definir point a droite de xi pour lequel la fonction est negative
fpos = 1;
step = .1*xi;
a = xi;
b = xi;
while fpos
   b = b + step;
   fpos = ( (GPDlogLsca(x,b,sigma,mu) - C) > 0 );
   step = 2*step;
end

it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = GPDlogLsca(x,c,sigma,mu) - C;
   fa = GPDlogLsca(x,a,sigma,mu) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in gpd_plci1'); end
end
zero(2) = mean([a b]); 

elseif ipar == 2   % Interval for sigma
% -------------------------------------
% Recherche du zero a gauche du maximum
% -------------------------------------
% Chercher un point a gauche de sigma pour lequel la fonction est negative
a = 0.001;
b = sigma;
if ~( (GPDlogLsca(x,xi,a,mu) - C) < 0 ) 
    disp('Choose appropriate value for a in GPD_PLCI1');
    keyboard
end
it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = GPDlogLsca(x,xi,c,mu) - C;
   fa = GPDlogLsca(x,xi,a,mu) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in gpd_plci1'); end
end
zero(1) = mean([a b]); 
%
% -------------------------------------
% Recherche du zero a droite du maximum
% -------------------------------------
% Chercher un point a droite de xi pour lequel la fonction est negative
fpos = 1;
step = .1*sigma;
a = sigma;
while fpos
   b = b + step;
   fpos = ( (GPDlogLsca(x,xi,b,mu) - C) > 0 );
   step = 2*step;
end

it = 0;
while abs(a-b) > delta
   c = (a+b)/2;
   fc = GPDlogLsca(x,xi,c,mu) - C;
   fa = GPDlogLsca(x,xi,a,mu) - C;
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
   it = it+1; if it > maxit, error('Maxit in gpd_plci1'); end
end
zero(2) = mean([a b]); 

else
end
