function logL = GPDlogLsca(x,xi,sigma,mu)
% Computes the Likelihood function of GPD
% Parametrs are scalars. x is the data vector
if sigma < 0, disp('sigma LOG negatif');sigma = eps;,end
n = length(x);
if xi > 0
   logL = - n * log(sigma) - (1/xi + 1)*sum(log(1 + xi/sigma * (x-mu)));
   if 1 + xi/sigma * (x - mu) < 0, disp('LOG negatif');keyboard,end
elseif xi < 0
   if any(x > (-sigma/xi+mu))
      logL = NaN;
   else
      logL = - n * log(sigma) - (1/xi + 1)*sum(log(1 + xi/sigma * (x-mu)));
      if 1 + xi/sigma * (x - mu) < 0, disp('LOG negatif');keyboard,end
   end
elseif xi == 0
   logL = - n * log(sigma) - ( sum(x) + n*mu )/sigma;
else
end


