function logL = GPDxiESLH(params,const,a,x)
% Reparameterized GPD (function of xi and ES)
% params    = vector of parameters to be estimated
% constants = vector of constants
if sum(a)==2
   xi = params(1);
   ES = params(2);
   mu = const(1);
   pstar = const(2);
elseif a(1)== 1 & a(2)==0   % a = [1 0]
   xi = params;
   ES = const(1);
   mu = const(2);
   pstar = const(3);
else % a = [0 1]
   xi = const(1);
   ES = params;
   mu = const(2);
   pstar = const(3);
end
%
y = x - mu;
f = GPDxiESpdf(y,xi,ES,pstar);
s = f > 0;
logL = -sum(log(f(s)));

