function f = GPDxiESpdf(y,xi,ESpu,pstar)
%
% Probability density function for the reparameterized GPD
% (function of xi and ES) 

if xi > 0
   c1 = pstar^(-xi);
   c2 = (1-xi)*ESpu;
   c3 = (xi + c1 -1) / c2;
   f  = c3 / xi * (1 + c3*y).^(-1/xi -1);
elseif xi < 0
   n = length(y);
   f = zeros(n,1);
   c1 = pstar^(-xi);
   c2 = (1-xi)*ESpu;
   c3 = (xi + c1 -1) / c2;
   s  = (1 + c3*y) > 0;
   f(s) = c3 / xi * (1 + c3*y(s)).^(-1/xi -1);
else
   error('x = 0 in GPDxiESpdf');
end