function zero = pl_ci_rnk(Rnkhat,Lhat,k,xihat,sigmahat,M,crit)
%
% --------------------------
% Recherche du zero a gauche
% --------------------------
% Chercher un point a gauche de Rnkhat pour lequel la fonction (profile - chi) est negative
delta = 1e-6;
phat  = [xihat sigmahat];
a = Rnkhat;
fpositive = 1;
while fpositive
   a = a - 1;   % Move to the left
   const = [a k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof = Lstar - Lhat;
   fpositive = ( (Lprof - crit) > 0 );
end
b = a + 1;     % Take last point where function is positive 
iter = 0;
while abs(a-b) > delta
   c = (a + b) / 2;
   iter = iter + 1;
   %
   const = [c k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof = Lstar - Lhat;
   fc = Lprof - crit;
   %
   const = [a k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof = Lstar - Lhat;
   fa = Lprof - crit;
   %
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
end
zero(1) = mean([a b]); 
iter1 = iter;
%
% --------------------------
% Recherche du zero a droite
% --------------------------
% Chercher un point a droite de beta pour lequel la fonction est negative
b = Rnkhat;
fpositive = 1;
while fpositive
   b = b + 1;
   const = [b k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof = Lstar - Lhat;
   fpositive = ( (Lprof - crit) > 0 );
end
a = b - 1;
iter = 0;
while abs(a-b) > delta
   c = (a + b) / 2;
   iter = iter + 1;
   %
   const = [c k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof = Lstar - Lhat;
   fc = Lprof - crit;
   %
   const = [a k];
   phat  = fminsearch('gevqlike',phat,[],const,[1 1 0],M);
   Lstar = -gevqlike(phat,const,[1 1 0],M);
   Lprof = Lstar - Lhat;
   fa = Lprof - crit;
   %
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
end
zero(2) = mean([a b]); 

