function zero = PL_ci_VaR(VaRp,Lhat,xihat,u,p_Fy,x,crit)
% --------------------------
% Recherche du zero a gauche
% --------------------------
% Chercher un point a gauche de VaRp pour lequel la fonction (profile - chi) est negative
delta = 1e-6;
phat  = xihat;
a = VaRp - u;
fpositive = 1;
while fpositive
   a = a - 0.1;   % Move to the left  !!! Think about a better increment than 0.1
   const = [a u p_Fy];
   phat = fminsearch('gpdqlike',xihat,[],const,[1 0],x);
   Lstar = -gpdqlike(phat, const,[1 0],x);
   Lprof = Lstar - Lhat;
   fpositive = ( (Lprof - crit) > 0 );
end
b = a + 0.1;     % Take last point where function is positive 
iter = 0;
while abs(a-b) > delta
   c = (a + b) / 2;
   iter = iter + 1;
   %
   const = [c u p_Fy];
   phat = fminsearch('gpdqlike',xihat,[],const,[1 0],x);
   Lstar = -gpdqlike(phat, const,[1 0],x);
   Lprof = Lstar - Lhat;
   fc = Lprof - crit;
   %
   const = [a u p_Fy];
   phat = fminsearch('gpdqlike',xihat,[],const,[1 0],x);
   Lstar = -gpdqlike(phat, const,[1 0],x);
   Lprof = Lstar - Lhat;
   fa = Lprof - crit;
   %
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
end
zero(1) = mean([a b]); 
iter1 = iter;
% --------------------------
% Recherche du zero a droite
% --------------------------
% Chercher un point a droite de beta pour lequel la fonction est negative
b = VaRp - u;
fpositive = 1;
while fpositive
   b = b + .1;
   const = [b u p_Fy];
   phat = fminsearch('gpdqlike',xihat,[],const,[1 0],x);
   Lstar = -gpdqlike(phat, const,[1 0],x);
   Lprof = Lstar - Lhat;
   fpositive = ( (Lprof - crit) > 0 );
end
a = b - .1;
iter = 0;
while abs(a-b) > delta
   c = (a + b) / 2;
   iter = iter + 1;
   %
   const = [c u p_Fy];
   phat = fminsearch('gpdqlike',xihat,[],const,[1 0],x);
   Lstar = -gpdqlike(phat, const,[1 0],x);
   Lprof = Lstar - Lhat;
   fc = Lprof - crit;
   %
   const = [a u p_Fy];
   phat = fminsearch('gpdqlike',xihat,[],const,[1 0],x);
   Lstar = -gpdqlike(phat, const,[1 0],x);
   Lprof = Lstar - Lhat;
   fa = Lprof - crit;
   %
   if fc*fa > 0
      a = c;
   else
      b = c;
   end
end
zero(2) = mean([a b]); 
zero = zero + u;  

