% ----------------------------------
% Peak over Threshold method   (POT)
% ----------------------------------
% Gilli and Kellezi, revision 01-Mai-2005
%
hold off, close all, clear all
rand('seed',987654321); fprintf('\n    ==> Seed set !!!!!!\n\n');

FS = 20;
Dset = str2mat('EuroXX','FTS','HS','Nikkei','SMI','SP','P');
for i = 1:size(Dset,1)
    fprintf(' %i  %s\n',i,Dset(i,:));
end
k = input('Give index for Dateset --> ');
load CSDA_data_c
eval(['r   = ',deblank(Dset(k,:)),'_ret;']);
eval(['dat = ',deblank(Dset(k,:)),'_dat;']);
n = length(r);
figure(1)
subplot(211), plot(dat,r,'k'), dateaxis('x',12), axis([dat(1) dat(n) -15 15])
% rep = input('Standardize returns (y/n) --> ','s');
% if strcmp(rep,'y')
%     [r,h,dat,n] = standardize(r,dat);
%     %[r,dat,n] = standardize(r,dat);
%     subplot(212), plot(dat,r,'k'), dateaxis('x',12), axis([dat(1) dat(n) -15 15])
% end
% Select  period
% n = datenum('31-Dec-1989');
% n = length(find(dat<=n));
disp([' ',deblank(Dset(k,:)),' (',datestr(dat(1)),' to ',datestr(dat(n)),')'])
% -----
LeftTail = 1;
if LeftTail
    x = -r(1:n); % -- We change the sign to make losses positive
    fprintf('\n *** Left Tail ***\n');
else
    x = r(1:n); fprintf('\n *** Right Tail ***\n');
end
minx = min(x);
maxx = max(x);

% ---- Eploratory data analysis -----

x = sort(x);
Fn = (1:n) ./ n;
figure(2)
plot(x,Fn,'.'); grid on, axis([1.5 15 .95 1.005])
title('Empirical distribution function');

% Empirical mean excess function  EKM p. 296

me = zeros(n-1,1);
for i = 1:n-1
    me(i) = mean(x(i+1:n) - x(i));
end
figure(3)
plot(x(1:n-1),me(1:n-1),'LineStyle','none',...
    'Marker','.','MarkerSize',8,'Color','k'),hold on
Nu = fix(0.05*length(x)); % 5% of lower tail
u = x(n-Nu);
%plot([u u],[0 me(n-Nu)],'r-','LineWidth',2), grid on
%set(gca,'Xtick',TickVals([-5 2.2 5],2),'FontSize',FS)
set(gca,'FontSize',20)
xlabel('u','FontSize',FS); %title('Sample mean excess function');

% Tail estimation  (ML estimator for GPD)

phat = [0.2 1];
fprintf('\n Threshold for 5%% excedences is %4.3f\n',u);
rep = input(' Choose different threshold u --> ');
if ~isempty(rep), u = rep; end
ndi = 2;
set(gca,'Xtick',TickVals([x(1) u x(n-1)],ndi),'FontSize',FS)
axis([x(1) x(n-1) 0 max(me)]); grid on
mu = u;
s = (x > u);
xtail = x(s);
Nu = length(xtail);
fprintf('\n Threshold u = %4.2f ',u);
fprintf(' (Obs. above u  Nu = %4i)\n',Nu);
Fu    = (n - Nu)/n;
phat  = fminsearch('GPDlogLvec',phat,[],xtail,u);
xi    = phat(1);
sigma = phat(2);
ucLLH = GPDlogLsca(xtail,xi,sigma,mu);

% QQ-plot -----

figure(4)
Fn_tail = (1:Nu) ./ (Nu+1);
yy = gpdinv(Fn_tail,xi,sigma,u);
plot(xtail,yy,'LineStyle','none','Marker','.','MarkerSize',8,'Color','k'); % mgqqplot(xtail,yy);
title(['QQ-plot against GPD  (u = ',num2str(u),')']);
%title(' '); xlabel(' '), ylabel(' ');   grid on
%
zz = linspace(u,1.5*max(xtail),200);
i = find(x > u);
Fn_i = interp1( x(i-1:i), Fn(i-1:i), u);
yy  = (1 - Fn_i) * gpdcdf(zz,xi,sigma,u) + Fn_i;
yy0 = (1 - Fn_i) * gpdcdf(zz, 0,sigma,u) + Fn_i;
%
figure(5)
yy  = (1 - Fu) * gpdcdf(zz,xi,sigma,u) + Fu;
plot(zz,yy,'r','LineWidth',2), hold on
plot(xtail,(1-Fu)*Fn_tail+Fu,'LineStyle','none','Marker','.','MarkerSize',8,'Color','k')
axis([0 25 0.98 1.001]), fontspec(20), grid on
%set(gca,'Xtick',TickVals([0 VaRp 10],ndi),'FontSize',FS)

% Compute profile likelihood-based confidence intervals for xi and sigma
% and joint intervals

alpha = .05; % <-- Level for confidence interval
crit1df = -.5*chi2inv(1-alpha,1); % 1 degree  of freedom
crit2df = -.5*chi2inv(1-alpha,2); % 2 degrees of freedom

% Bootstrap done here in order to define window size for next fig
B = 1000;   % <-- Number of replications
ML = mgbootstrp(B,'GPDML',xi,sigma,xtail,u);

xswindow = [0.9*min(ML(:,1)) 1.1*max(ML(:,1)) 0.9*min(ML(:,2)) 1.1*max(ML(:,2))];   % window for xi sigma plot (optional argument)

figure(6)
[ci_xi, ci_sigma] = GPD_PLci0(xi,sigma,mu,xtail,[alpha alpha],xswindow);

fprintf('\n Point estimates and (%2i%%) confidence intervals of POT\n',fix(100*(1-alpha)));
fprintf('\n                        xi                   sigma');
fprintf('\n         ML: (%5.3f < %5.3f < %4.3f)',ci_xi(1,1),   xi,   ci_xi(1,2));
fprintf('  (%4.3f < %5.3f < %4.3f)',ci_sigma(1,1),sigma,ci_sigma(1,2));

BstrpInt(ML,xi,sigma,xtail,u,alpha); % Bootstrap intervalls
% Compute VaRp and ESp
p    = .01;         % <-- Give level for VaR and ES
p_Fy = n * p / Nu;   % Compute corresponding p in F_u(y)
VaRp = u + (sigma/xi) * ( (n/Nu*p)^-xi - 1 );
ESp  = VaRp / (1-xi) + (sigma - xi*u)/(1-xi);

% Compute confidence interevalls for VaRp

figure(7)
VaRci = PL_ci_VaR(VaRp,ucLLH,xi,u,p_Fy,xtail,crit1df);
ESci  = PL_ci_ES(  ESp,ucLLH,xi,u,p_Fy,xtail,crit1df);

fprintf('\n\n                       xi                     VaR');
fprintf('\n         ML:                      ');
fprintf('   (%4.3f < %5.3f < %4.3f)',VaRci(1,1),VaRp,VaRci(1,2));

VaRpoints = 200;
VaRi = linspace(0.9*VaRci(1),1.2*VaRci(2),VaRpoints);
Lprof = zeros(VaRpoints,1);
for i = 1:VaRpoints
    const = [VaRi(i)-u u p_Fy];
    phat  = fminsearch('gpdqlike',xi,[],const,[1 0],xtail);
    Lstar = -gpdqlike(phat,const,[1 0],xtail);
    Lprof(i) = Lstar - ucLLH;
end
plot(VaRi,Lprof,'r','LineWidth',2); hold on,
plot(VaRci,[crit1df crit1df],'LineStyle','none','Marker','o','MarkerSize',12,'Color','r')
plot(VaRp,0,'LineStyle','none','Marker','o','MarkerSize',12,'Color','r')
plot(VaRp,0,'LineStyle','none','Marker','*','MarkerSize',12,'Color','r')
ndi = 3;
set(gca,'Xtick',TickVals([VaRci(1) VaRp VaRci(2)],ndi),'FontSize',FS)
set(gca,'Ytick',TickVals([crit1df 0],ndi),'FontSize',FS)
grid on
xlabel('VaR_0_._0_1','FontSize',FS), grid on
axis([.95*VaRci(1) 1.15*VaRci(2) 5*crit1df 1])
xlim([2.3 2.6])

% Compute the relative profile Lstar - Lhat for contours VaRp and xi
figure(8)
Npoints = 100;
VaRi = linspace(0.9*VaRci(1),1.2*VaRci(2),Npoints);
xii = linspace(0.6*ci_xi(1,1),1.4*ci_xi(1,2),Npoints);
L = repmat(NaN,Npoints,Npoints);
h = waitbar(0,' Computing VaR profile ...');
for i = 1:Npoints
    for j = 1:Npoints
        L(i,j) = -gpdqlike([xii(j) VaRi(i)-u], [u p_Fy],[1 1],xtail);
    end; waitbar(i/Npoints,h)
end, close(h)
contour(VaRi,xii,L'-ucLLH,[crit2df crit2df],'r','LineWidth',2); hold on
plot(VaRp,xi,'LineStyle','none','Marker','*','MarkerSize',8,'Color','r');
plot([VaRci(1) VaRci(1) VaRci(2) VaRci(2) VaRci(1)],...
    [ci_xi(1,1) ci_xi(1,2) ci_xi(1,2) ci_xi(1,1) ci_xi(1,1)],'r','LineWidth',2);
xlim([2.3 2.5]);
xlabel('VaR_0_._0_1','FontSize',FS);
ylabel('\xi','Rotation',0,'FontSize',FS);

% Bootstrap VaR and xi statistics
ML = mgbootstrp(B,'gpdqsimboot',xtail,u,p_Fy,xi);
BstrpIntV2('gpdqlike',ML,VaRp,xi,xtail,u,p_Fy,alpha);
axis([0.99*min(ML(:,1)) 1.01*max(ML(:,1)) 0.99*min(ML(:,2)) 1.01*max(ML(:,2))]);

% Compute confidence interevalls for ESp

fprintf('\n\n                       xi                      ES');
fprintf('\n         ML:                      ');
fprintf('   (%4.3f < %5.3f < %4.3f)',ESci(1,1),ESp,ESci(1,2));

ESpoints = 200;
ESi = linspace(0.9*ESci(1),1.2*ESci(2),ESpoints);
Lprof = zeros(ESpoints,1);
for i = 1:ESpoints
    const = [ESi(i)-u u p_Fy];
    phat  = fminsearch('GPDxiESLH',xi,[],const,[1 0],xtail);
    Lstar = -GPDxiESLH(phat,const,[1 0],xtail);
    Lprof(i) = Lstar - ucLLH;
end
figure(9)
plot(ESi,Lprof,'r','LineWidth',2); hold on,
%plot([.8*ESci(1) 1.4*ESci(2)],[crit1df crit1df],'-.')
plot(ESci,[crit1df crit1df],'LineStyle','none','Marker','o','MarkerSize',12,'Color','r')
plot(ESp,0,'LineStyle','none','Marker','*','MarkerSize',12,'Color','r')
plot(ESp,0,'LineStyle','none','Marker','o','MarkerSize',12,'Color','r')
ndi = 3;
set(gca,'Xtick',TickVals([ESci(1) ESp ESci(2)],ndi),'FontSize',FS)
set(gca,'Ytick',TickVals([crit1df 0],ndi),'FontSize',FS), grid on
xlabel('ES_0_._0_1','FontSize',FS)
axis([.95*ESci(1) 1.15*ESci(2) 5*crit1df 1])

% Compute the relative profile Lstar - Lhat for contours ESp and xi

ESpoints = 100;
ESi = linspace(0.9*ESci(1),1.2*ESci(2),ESpoints);
xipoints = 100;
xii = linspace(0.6*ci_xi(1,1),1.4*ci_xi(1,2),xipoints);
L = zeros(xipoints,ESpoints);
h = waitbar(0,' Computing ES profile ...');
for i = 1:xipoints
    for j = 1:ESpoints
        L(i,j) = -GPDxiESLH([xii(j) ESi(i)-u], [u p_Fy],[1 1],xtail);
    end
    waitbar(i/xipoints,h)
end, close(h)

figure(10)
contour(ESi,xii,L'-ucLLH,[crit2df crit2df],'r','LineWidth',2); hold on
axis([3 6  0 .7])
plot(ESp,xi,'LineStyle','none','Marker','*','MarkerSize',15,'Color','r');
plot(ci_xi(1,:),[ci_sigma(1,1) ci_sigma(1,1)],'r',ci_xi(1,:),[ci_sigma(1,2) ci_sigma(1,2)],'r','LineWidth',2);
plot([ESci(1) ESci(1) ESci(2) ESci(2) ESci(1)],[ci_xi(1,1) ci_xi(1,2) ci_xi(1,2) ci_xi(1,1) ci_xi(1,1)],'r','LineWidth',2);
xlabel('ES_0_._0_1','FontSize',FS);
ylabel('\xi','Rotation',0,'FontSize',FS);

% Bootstrap xi and ES statistics
ML = mgbootstrp(B,'GPDxiESsimboot',xtail,u,p_Fy,xi);
BstrpIntV2('GPDxiESLH',ML,ESp,xi,xtail,u,p_Fy,alpha);

axis([0.99*min(ML(:,1)) 1.01*max(ML(:,1)) 0.99*min(ML(:,2)) 1.01*max(ML(:,2))]);
fprintf('\n');