function y = gevpdf(x,xi,mu,sigma)
% GEVPDF GEV probability density function (pdf).

[m,n] = size(x);
y = zeros(m,n);
if xi==0
   I = logical(ones(m,n));
elseif xi < 0
   I = x < mu-sigma/xi;
   a = find(I);
elseif xi > 0
   I = x > mu-sigma/xi;
   a = find(I);
else
end
x = x(I);
c = 1+xi*(x-mu)/sigma;
if  xi ~= 0
   y(a) = 1/sigma*(c).^(-1/xi-1).*exp(-(c).^(-1/xi));
elseif xi == 0
   y = (1/sigma*exp(-(x-mu)/sigma)) .* exp(-exp(-(x-mu)/sigma));
else
end

