function y = gevqcdf(x,xi,sigma,Rnk,k)
% GEVQCDF GEV Quantile cumulative density function (cdf).

[m,n] = size(x);
y = zeros(m,n);
if xi==0
   I = logical(ones(m,n));
elseif xi < 0
   I = x < (Rnk*xi-(-log(1-1/k))^(-xi))*sigma/xi;
   a = find(I);
   aa = find(~I);
else %xi>0
   I = x > (Rnk*xi-(-log(1-1/k))^(-xi))*sigma/xi ;
   a = find(I);
end
x = x(I); 
if xi < 0
   y(a)  = exp(-(xi*(x-Rnk)/sigma+(-log(1-1/k))^(-xi)).^(-1/xi));
   y(aa) =1;
elseif xi > 0;
   y(a)  = exp(-(xi*(x-Rnk)/sigma+(-log(1-1/k))^(-xi)).^(-1/xi));
else  %xi==0
   y = (1-1/k).^exp(-(x-Rnk)/sigma);
end

