function logL = gevqlike(params,const,a,x)
% GEVLIKE GEV log-likelihood function.

% params : vector of parameters to be estimated
% const  : vector of constants
if sum(a)==3                            % a = [1 1 1]
   xi    = params(1);
   sigma = params(2);
   Rnk   = params(3);
   k     = const;
elseif sum(a)==2
   if a(1)==1 & a(2)==1 & a(3)==0       % a = [1 1 0]
      xi    = params(1);
      sigma = params(2);
      Rnk   = const(1);
      k     = const(2);
   elseif a(1)== 1 & a(2)==0 & a(3)==1  % a = [1 0 1]
      xi    = params(1);
      sigma = const(1);
      Rnk   = params(2);
      k     = const(2);
   else                                 % a = [0 1 1]
      xi    = const(1);
      sigma = params(1);
      Rnk   = params(2);
      k     = const(2);
   end
else
   if a(1)==1 & a(2)==0 & a(3)==0       % a = [1 0 0]
      xi    = params;
      sigma = const(1);
      Rnk   = const(2);
      k     = const(3);
   elseif a(1)==0 & a(2)==1 & a(3)==0   % a = [0 1 0]
      xi    = const(1);
      sigma = params;
      Rnk   = const(2);
      k     = const(3);
   else                                 % a = [0 0 1]
      xi    = const(1);
      sigma = const(2);
      Rnk   = params;
      k     = const(3);
   end
end
%
y = gevqpdf(x,xi,sigma,Rnk,k);
%
logL = -sum(log(y+eps));
