function y = gevqpdf(x,xi,sigma,Rnk,k)
% GEVQPDF GEV Quantile probability density function (pdf).
 
[m,n] = size(x);
y = zeros(m,n);
if xi==0
   I = logical(ones(m,n));
elseif xi < 0
   %I = x < (Rnk*xi-(-log(1-1/k))^(-xi))*sigma/xi;
   I = (xi/sigma*(x-Rnk)+(-log(1-1/k))^(-xi)) > 0 ;
   a = find(I);
else %xi>0
   %    I = x > (Rnk*xi-(-log(1-1/k))^(-xi))*sigma/xi ;
   I = (xi/sigma*(x-Rnk)+(-log(1-1/k))^(-xi)) > 0 ;      % !!!!!!!!!
   a = find(I);
end
x = x(I);
if xi ~= 0
   y0 = xi/sigma*(x-Rnk)+(-log(1-1/k))^(-xi);
   y1 = 1/sigma*(y0).^(-1-1/xi);  
   y2 = exp(-y0.^(-1/xi));
   y(a) = y1.*y2; 
else %xi==0
   y = -((1-1/k).^exp(-(x-Rnk)/sigma)).*exp(-(x-Rnk)/sigma)*log(1-1/k)/sigma;
end

   




