function F = gpdcdf(x,xi,sigma,mu)
% 
% GPD distribution function
%
if nargin == 3
   mu = 0;
end
%
if xi > 0
   F    = 1 - ( 1 + (xi/sigma) * (x   -mu) ).^(-1/xi);
elseif xi < 0
   n = length(x);
   F = ones(n,1);
   s = ( (x-mu) < -sigma/xi );
   F(s) = 1 - ( 1 + (xi/sigma) * (x(s)-mu) ).^(-1/xi);
elseif xi == 0
   F = 1 - exp( -(x-mu)./sigma );
else
end
