function x = gpdinv(u,xi,sigma,mu)
%
% Inverse of the GPD(xi,sigma,mu)
%
if xi > 0
   x = mu + sigma / xi * ( ( 1 - u ).^(-xi) - 1 );
elseif xi < 0
   x = mu + sigma / xi * ( ( 1 - u ).^(-xi) - 1 );
   if max(x) > (-sigma/xi + mu), warning('Problem in GPDINV'); end
elseif xi == 0
   x = -mu - sigma * log(1-u);  
else
end




