function logL = gpdqlike(params,const,a,x)
% GPDQLIKE GPD quantile log-likelihood function.

% params : vector of parameters to be estimated
% const  : vector of constants
if sum(a)==2
   xi = params(1);
   yp = params(2);
   mu = const(1);
   p = const(2);
elseif a(1)== 1 & a(2)==0   % a = [1 0]
   xi = params;
   yp = const(1);
   mu = const(2);
   p = const(3);
else % a = [0 1]
   xi = const(1);
   yp = params;
   mu = const(2);
   p = const(3);
end
%
y = gpdqpdf(x,xi,yp,p,mu);
%
logL = -sum(log(y+eps));
