function f = gpdqpdf(x,xi,yp,p,mu)
% GPDQPDF GPD quantile probability density function (pdf).
%
y = x - mu;
if xi > 0
   c = (1+(p^(-xi)-1)*y/yp);
   f = c .^(-1/xi-1).*(p^(-xi)-1)/(xi*yp);
elseif xi < 0
   n = length(x);
   f = zeros(n,1);
   s = (1+(p^(-xi)-1)*y/yp) > 0;
   c = (1+(p^(-xi)-1)*y(s)/yp);
   f(s) = c .^(-1/xi-1).*(p^(-xi)-1)/(xi*yp);
elseif xi == 0
   f = -p.^(y/yp)*log(p)/yp;
else
end





