function ML = gpdqsimboot(xtail,u,p_Fy,xi0)
% Same as gpdsimboot but modified to called by bootstr
%
maxit = 200;
options = optimset('fminsearch');
options = optimset('MaxIter',maxit);
phat = [xi0 0.66];
const = [u p_Fy];
[phat,F,flag,output] = fminsearch('gpdqlike',phat,[],const,[1 1],xtail);
VaR = phat(2) + u;
if output.iterations < maxit
    ML = [VaR phat(1)];
else
    ML = [NaN NaN];
end

