function ML = gpdsimboot(xtail,mu)
% Same as gpdsim but modified to called by bootstr
%
maxit = 200;
phat0 = [0.35 0.66];
options = optimset('fminsearch');
options = optimset('MaxIter',maxit);
% Tail estimation  (ML estimator for GPD)
[phat,F,flag,output] = fminsearch('gpd_ml',phat0,options,xtail,mu);
if output.iterations < maxit
    ML = phat;
else
    ML = [NaN NaN];
end

