
# README for replication materials for Frech, Goet, and Hug, “Shirking and Slacking in Parliament: , 1811-2015.”

This README file describes the contents of each folder in the replication data repository.

# SETUP AND BENCHMARKS
## OS
Original code run on MAC OSX 10.14, 16gb RAM, 1 cpu (2.5GHz), 4 cores.

## Benchmarks
Estimates of run times for the scripts to produce the results of the main analyses and of the supplementary materials are outlined below. 

All scripts listed below are called and executed through a single script (`replicate.R`, see details below). This script also installs all dependencies, provided you uncomment the relevant lines at the start of the script. 

### Main analysis
Run time per script (in order of replication): 

* `replicate.R`: 10 minutes

### On-line supplementary materials
Estimated run time per script (in order of replication): 

# R SCRIPTS
The R scripts is optimised to run in RStudio.

Dependencies:

* ggplot2
* bcp
* strucchange
* foreign
* optimx
* lme4
* grid
* stargazer
* spduration
* survival

# Replication process
Prior to running the replication process, please unzip the replication folder. The folder structure needs to be maintained for the replication process to be successful. The complete replication (of figures and tables) can be achieved by running the `replicate.R`
script. 


# FOLDERS
## figures
All generated figures are saved to this folder. 

## regTables
* All generated regression tables are saved to this folder.

## data
Contains the data required to run the replication. Files/folders include:

* `CH_NR_SR_47-50_TL_Dataset_FINAL.csv`: Metadata for MPs, including their time in office and retirement, re-election, or term limits. 
* `person_ids_parties.csv`: Metadata linking MPs to their respective parties.
* `MLEstimatesLowerH`: Folder that contains the machine classifier output for MP speeches in the Lower House (approach described in article).
* `MLEstimatesUpperH`: Folder that contains the machine classifier output for MP speeches in the Upper House (approach described in article).
* `SpeechDataLowerH`: Folder that contains the raw speech data for speeches made in the Lower House (1999-2015).
* `SpeechDataUpperH`: Folder that contains the raw speech data for speeches made in the Upper House (1999-2015).
* `votes_data`: Folder that contains voting data from the Lower House (2003-2015). 
* `basel_land`: Folder that contains data for Basel-Land.
* `basel_stadt`: Folder that contains data for Basel-Stadt.
* `sasip_ch`: Folder that contains data for our analysis of shirking at the national level towards cantons. 

## dependencies
Contains custom R functions and scripts to replicate our analyses. These functions are dependencies for `replicate.R`. Scripts include:

* `sasip_bl.r`: Code to replicate our analyses for the Basel-Land canton.
* `sasip_bs.r`: Code to replicate our analyses for the Basel-Stadt canton.
* `sasip_ch.r`: Code to replicate our analyses of shirking from local cantons at the federal level. 
* `speech_analysis.R`: Code to replicate our analyses of shirking and slacking based on speech data in the Lower and Upper Houses. 
* `votes_analysis.R`: Code to replicate our analyses of shirking and slacking based on voting patterns in the Lower and Upper Houses. 
* `calc_vote_loyalty.R`: Dependency for `votes_analysis.R`, used to estimate party loyalty based on voting patterns. 
* `ECDF_plots.R`: Code to generate the ECDF plot reported in the on-line supplementary materials (figure 2).
* `coefplots.R`: Code to generate all coefficient plots reported in the paper.

## saved_models
Contains model output in .Rdata format, which are used to generate coefficient plots.


