# ==========================
# COEFFICIENT PLOTS
# ==========================
# Authors: Simon Hug & ngoet
# First version: 7.8.2018
# This version: 10.8.2018


############
#Slacking
#models
load("saved_models/mod4748slacking.RData")
load("saved_models/diffmod47_48slackingAbstention.RData")
load("saved_models/diffmod47_48NoParticipation.RData")
load("saved_models/ch_r4act.rda")
load("saved_models/blabs.rda")
load("saved_models/blabst.rda")
load("saved_models/blact.rda")
load("saved_models/bs_reg_abs.rda")
load("saved_models/bs_reg_abst.rda")
load("saved_models/bs_reg_act.rda")

mod4748slacking # speeches
diffmod47_48slackingAbstention #vote abstention
diffmod47_48NoParticipation #vote non-participation

blact # activities
blabs #vote abstention
blabst #vote non-participation


library(arm)
plotDat <- rbind(data.frame(summary(mod4748slacking)$coefficients),
                 data.frame(summary(diffmod47_48slackingAbstention)$coefficients),
                 data.frame(summary(diffmod47_48NoParticipation)$coefficients),
                 data.frame(summary(r4act)$coefficients),
                 data.frame(summary(blabs)$coefficients),
                 data.frame(summary(blabst)$coefficients),
                 data.frame(summary(blact)$coefficients),
                 data.frame(summary(reg_abs)$coefficients),
                 data.frame(summary(reg_abst)$coefficients),
                 data.frame(summary(bs_act)$coefficients)                 )
plotDat <- data.frame(var = rownames(plotDat),
                      estimate=plotDat$Estimate,
                      se = plotDat$Std..Error)

plotDat <- plotDat[plotDat$var %in% c("TermLimit",
                                      "`Term limited`",
                                      "retired",
                                      "Retiring",
                                      "TermLimit1",
                                      "Retiring1",
                                      "TermLimit2",
                                      "tl48",
                                      "ret48",
                                      "tl",
                                      "tl1",
                                      "tl2"     ,
                                      "tl3",
                                      "tl4"     ,
                                      "tl5"
),]

                       
longNames <- c("term limited",
               "voluntary retirement",      
               "term limited",
               "voluntary retirement",
               "term limited",
               "voluntary retirement",
               "term limited",
               "voluntary retirement",
               "term limited",
               "term limited",
               "term limited",
               "term limited",
               "term limited",
               "term limited")

#B E W A R E: I change scale of three coefficients and their ses
plotDat$estimate[c(grep("tl48",plotDat$var),grep("tl2",plotDat$var),grep("tl5",plotDat$var),grep("ret48",plotDat$var))]<- plotDat$estimate[c(grep("tl48",plotDat$var),grep("tl2",plotDat$var),grep("tl5",plotDat$var),grep("ret48",plotDat$var))]/100

plotDat$se[c(grep("tl48",plotDat$var),grep("tl2",plotDat$var),grep("tl5",plotDat$var),grep("ret48",plotDat$var))]<- plotDat$se[c(grep("tl48",plotDat$var),grep("tl2",plotDat$var),grep("tl5",plotDat$var),grep("ret48",plotDat$var))]/100

library(arm)
pdf(file="figures/coefPlotSpeechSlackingCombined2.pdf",height=6,width = 8)
coefplot(plotDat$estimate,plotDat$se,mar=c(1,5,5,2),main="Slacking: Diff-in-diff in activities",varnames=longNames)
           
           text(-.20,2.25, "National parliament: participation (speeches)",pos=4)
#           text(-220,1.25, "National parliament: participation (speeches)",pos=4)
#           text(-220,3.25, "National parliament: abstention (votes)",pos=4)
           text(-.20,4.25, "National parliament: abstention (votes)",pos=4)
           text(-.20,6.25, "National parliament: non-participation (votes)",pos=4)
#           text(-220,5.25, "National parliament: non-participation (votes)",pos=4)
           text(-.20,8.25, "National parliament: activities (in 100)",pos=4)
           text(-.20,9.25, "Basel-Land parliament: absences (votes)",pos=4)
           text(-.20,10.25, "Basel-Land parliament: abstention (votes)",pos=4)
           text(-.20,11.25, "Basel-Land parliament: activities (in 100) ",pos=4)
           text(-.20,12.25, "Basel-Stadt parliament: absences (votes)",pos=4)
           text(-.20,13.25, "Basel-Stadt parliament: abstention (votes)",pos=4)
           text(-.20,14.25, "Basel-Stadt parliament: activities (in 100)",pos=4)
dev.off()
           


#shirking
#########
load("saved_models/mod4748shirking.RData")
load("saved_models/diffmod47_48VoteLoyalty.RData")
load("saved_models/ch_partydis.rda")
load("saved_models/ch_cantdis.rda")
load("saved_models/blloy.rda")
load("saved_models/bs_reg_ly.rda")

library(arm)
plotDat <- rbind(
  data.frame(summary(mod4748shirking)$coefficients),
data.frame(summary(r4748)$coefficients),
data.frame(summary(r4748c)$coefficients),
data.frame(summary(diffmod47_48VoteLoyalty)$coefficients),
data.frame(summary(blloy)$coefficients),
data.frame(summary(reg_ly)$coefficients))

plotDat <- data.frame(var = rownames(plotDat),
estimate=plotDat$Estimate,
se = plotDat$Std..Error)

plotDat <- plotDat[plotDat$var %in% c("TermLimit",
                                      "`Term limited`",
                                      "retired",
                                      "Retiring",
                                      "tl48",
                                      "I((1 - tl48) * ret48)",
                                      "tl481",
                                      "I((1 - tl48) * ret48)1",
                                      "tl"  ,
"tl_2016",
"Retiring1",
"TermLimit1"
           ),]
           
           longNames <- c("term limited",
                          "voluntary retirement",
             "term limited",
                                  "voluntary retirement",
"term limited",
                                  "voluntary retirement",
"term limited",
                                  "voluntary retirement",
"term limited",
"term limited"
           )
           
#B E W A R E: I change the sign of four coefficients
plotDat$estimate[grep("tl48",plotDat$var)]<- -plotDat$estimate[grep("tl48",plotDat$var)]

library(arm)
pdf(file="figures/coefPlotSpeechShirkingCombined2.pdf",height=6,width = 8)
coefplot(plotDat$estimate,plotDat$se,mar=c(1,5,5,2),main="Shirking: Diff-in-diff in Loyalty and Closeness to Party",varnames=longNames)        
           text(-0.2,2.25, "National parliament: closeness (speeches)",pos=4)
#           text(-0.5,1.25, "National parliament: partyness (speeches)",pos=4)
#           text(-0.5,3.25, "National parliament: distance to party (votes)",pos=4)
           text(-0.2,4.25, "National parliament: closeness to party (votes)",pos=4)
           
           text(-0.2,8.25, "National parliament: loyalty to party (votes)",pos=4)
#           text(-0.5,5.25, "National parliament: distance to canton (votes)",pos=4)
           text(-0.2,6.25, "National parliament: closeness to canton (votes)",pos=4)
           text(-0.2,9.25, "Basel-Land parliament: loyalty to party (votes)",pos=4)
           text(-0.2,10.25, "Basel-Stadt parliament: loyalty to party (votes)",pos=4)
dev.off()           
           
           
