#Author: ngoet
#First version: 7.8.2018
#This version:6.3.2020

############
#Slacking
#models
load("saved_models/mod4748slacking.RData")
load("saved_models/diffmod47_48slackingAbstention.RData")
load("saved_models/diffmod47_48NoParticipation.RData")
load("saved_models/ch_r4act_new.rda")
load("saved_models/ch_sr_abs.rda")
load("saved_models/ch_sr_abst.rda")
load("saved_models/blabs.rda")
load("saved_models/blabst.rda")
load("saved_models/blact.rda")
load("saved_models/bs_reg_abs.rda")
load("saved_models/bs_reg_abst.rda")
load("saved_models/bs_reg_act.rda")

mod4748slacking # speeches
diffmod47_48slackingAbstention #vote abstention
diffmod47_48NoParticipation #vote non-participation

blact # activities
blabs #vote abstention
blabst #vote non-participation


library(arm)
plotDat <- rbind(data.frame(summary(mod4748slacking)$coefficients),
                 data.frame(summary(diffmod47_48slackingAbstention)$coefficients), data.frame(summary(abstr)$coefficients),
                 data.frame(summary(diffmod47_48NoParticipation)$coefficients),
                 data.frame(summary(absr)$coefficients),
                 data.frame(summary(r4act)$coefficients),
                 data.frame(summary(blabs)$coefficients),
                 data.frame(summary(blabst)$coefficients),
                 data.frame(summary(blact)$coefficients),
                 data.frame(summary(reg_abs)$coefficients),
                 data.frame(summary(reg_abst)$coefficients),
                 data.frame(summary(bs_act)$coefficients)                 )
plotDat <- data.frame(var = rownames(plotDat),
                      estimate=plotDat$Estimate,
                      se = plotDat$Std..Error)

plotDat <- plotDat[plotDat$var %in% c("TermLimit",
                                      "`Term limited`",
                                      #                                      "retired",
                                      #                                      "Retiring",
                                      "TermLimit1",
                                      #                                     "Retiring1",
                                      "TermLimit2",
                                      "I(tl48)",
                                      #                                    "I((1 - tl48) * ret48)",
                                      "tl",
                                      "tl1",
                                      "tl2"     ,
                                      "tl3",
                                      "tl4"     ,
                                      "tl5"    ,
                                      "tl6"    ,
                                      "tl7"
),]


longNames <- c("National parliament: \n participation (speeches)",
               #               "voluntary retirement",      
               "National parliament: \n abstention (votes: lower house)",
               #              "voluntary retirement",
               "National parliament: \n abstention (votes: upper house)",
               #             "voluntary retirement",
               "National parliament: non-\n participation (votes: lower house)",
               #            "voluntary retirement",
               "National parliament: \n non-participation (votes: upper house)",
               "National parliament:\n activities (in 100)",
               "Basel-Land parliament:\n non-participation (votes)",
               "Basel-Land parliament:\n abstention (votes)",
               "Basel-Land parliament:\n activities (in 100)",
               "Basel-Stadt parliament:\n non-participation (votes)",
               "Basel-Stadt parliament:\n abstention (votes)",
               "Basel-Stadt parliament:\n activities (in 100)")

#B E W A R E: I change scale of three coefficients and their ses
plotDat$estimate[c(grep("tl48",plotDat$var),grep("tl4",plotDat$var),grep("tl7",plotDat$var))]<- plotDat$estimate[c(grep("tl48",plotDat$var),grep("tl4",plotDat$var),grep("tl7",plotDat$var))]/100

plotDat$se[c(grep("tl48",plotDat$var),grep("tl4",plotDat$var),grep("tl7",plotDat$var))]<- plotDat$se[c(grep("tl48",plotDat$var),grep("tl4",plotDat$var),grep("tl7",plotDat$var))]/100

library(arm)
coefplot(plotDat$estimate,plotDat$se,mar=c(1,8,5,2),main="Slacking: Diff-in-diff in activities",varnames=longNames)

#           text(-.20,1.25, "National parliament: participation (speeches)",pos=4)
##           text(-220,1.25, "National parliament: participation (speeches)",pos=4)
##           text(-220,2.25, "National parliament: abstention (votes)",pos=4)
#           text(-.20,2.25, "National parliament: abstention (votes: lower house)",pos=4)
#           text(-.20,3.25, "National parliament: abstention (votes: upper house)",pos=4)
#           text(-.20,4.25, "National parliament: non-participation (votes: lower house)",pos=4)
#           text(-.20,5.25, "National parliament: non-participation (votes: upper house)",pos=4)
##           text(-220,3.25, "National parliament: non-participation (votes)",pos=4)
#           text(-.20,6.25, "National parliament: activities (in 100)",pos=4)
#           text(-.20,7.25, "Basel-Land parliament: non-participation (votes)",pos=4)
#           text(-.20,8.25, "Basel-Land parliament: abstention (votes)",pos=4)
#           text(-.20,9.25, "Basel-Land parliament: activities (in 100) ",pos=4)
#           text(-.20,10.25, "Basel-Stadt parliament: non-participation (votes)",pos=4)
#           text(-.20,11.25, "Basel-Stadt parliament: abstention (votes)",pos=4)
#           text(-.20,12.25, "Basel-Stadt parliament: activities (in 100)",pos=4)
dev.copy2pdf(file="figures/coefPlotSpeechSlackingCombined2n.pdf",height=8,width = 8)



#shirking
#########
load("saved_models/mod4748shirking.RData")
load("saved_models/diffmod47_48VoteLoyalty.RData")
load("saved_models/ch_partydis_new.rda")
load("saved_models/ch_cantdis_new.rda")
load("saved_models/blloy.rda")
load("saved_models/bs_reg_ly.rda")
load("saved_models/ch_sr_loy.rda")

library(arm)
plotDat <- rbind(
  data.frame(summary(mod4748shirking)$coefficients),
  data.frame(summary(r4748)$coefficients),
  data.frame(summary(r4748c)$coefficients),
  data.frame(summary(diffmod47_48VoteLoyalty)$coefficients),
  data.frame(summary(loyr)$coefficients),
  data.frame(summary(blloy)$coefficients),
  data.frame(summary(reg_ly)$coefficients))

plotDat <- data.frame(var = rownames(plotDat),
                      estimate=plotDat$Estimate,
                      se = plotDat$Std..Error)

plotDat <- plotDat[plotDat$var %in% c("`Term limited`",
                                      "tl48",
                                      "tl481",
                                      "TermLimit",
                                      "tl"  ,
                                      "tl1" ,
                                      "tl2" 
),]

longNames <- c("National parliament:\n closeness (speeches)",
               "National parliament:\n closeness to party (votes)",
               "National parliament:\n closeness to canton (votes)",
               "National parliament (lower\n house): loyalty to party (votes)",
               "National parliament (upper\n house): loyalty to party (votes)",
               "Basel-Land parliament:\n loyalty to party (votes)",
               "Basel-Stadt parliament:\n loyalty to party (votes)"           )

#B E W A R E: I change the sign of four coefficients
plotDat$estimate[grep("tl48",plotDat$var)]<- -plotDat$estimate[grep("tl48",plotDat$var)]

library(arm)
arm::coefplot(plotDat$estimate,plotDat$se,mar=c(1,5,5,2),main="Shirking: Diff-in-diff in Loyalty and Closeness to Party",varnames=longNames) 
#(plotDat))

#           text(-0.2,1.25, "National parliament: closeness (speeches)",pos=4)
##           text(-0.5,1.25, "National parliament: partyness (speeches)",pos=4)
##           text(-0.5,3.25, "National parliament: distance to party (votes)",pos=4)
#           text(-0.2,2.25, "National parliament: closeness to party (votes)",pos=4)
#           
#           text(-0.2,3.25, "National parliament: loyalty to party (votes)",pos=4)
##           text(-0.5,5.25, "National parliament: distance to canton (votes)",pos=4)
#           text(-0.2,4.25, "National parliament: closeness to canton (votes)",pos=4)
#           text(-0.2,5.25, "Basel-Land parliament: loyalty to party (votes)",pos=4)
#           text(-0.2,6.25, "Basel-Stadt parliament: loyalty to party (votes)",pos=4)
#dev.off()           
dev.copy2pdf(file="figures/coefPlotSpeechShirkingCombined2n.pdf",height=6,width = 8)

