### Analyses for Basel-Land
load(file="saved_models/bl_total_data.rda")

summary(blloy<-lm(loy_2nd-loy_1st~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(paste(X3))),
data=bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20),6]))]
&bl_mps_tot_df$X2!="Parteilos",]))


summary(blabs<-lm(abs_2nd-abs_1st~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(paste(X3))),
data=bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20),6]))]
,]))


summary(blabst<-lm(abst_2nd-abst_1st~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(paste(X3))),
data=bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20),6]))]
,]))

summary(blact<-lm(nact2-nact1~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(paste(X3))),
data=bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(paste(bl_mps_tot_df[,6]))<20),6]))]
,]))


save(blabs,file="saved_models/blabs.rda")
save(blabst,file="saved_models/blabst.rda")
save(blact,file="saved_models/blact.rda")
save(blloy,file="saved_models/blloy.rda")
library(apsrtable)
apsrtable(blloy,blabs,blabst,blact,model.names=c("loyalty","absences","abstentions","activities"))
stargazer(blloy,blabs,blabst,blact,column.labels=c("loyalty","absences","abstentions","activities"))
stargazer(blloy,column.labels=c("loyalty"))
stargazer(blabs,blabst,blact,column.labels=c("absences","abstentions","activities"))


summary(blloy<-lm(loy_2nd~loy_1st+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),
data=bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20),6]))]
&bl_mps_tot_df$X2!="Parteilos",]))

blloy_2012<-model.frame(blloy)
blloy_2016<-model.frame(blloy)
blloy_2012$dt<-0
blloy_2016$dt<-1

blloy_2012$loys<-blloy_2012$loy_1st
blloy_2016$loys<-blloy_2016$loy_2nd

blloy_tot<-rbind(blloy_2012,blloy_2016)
names(blloy_tot)<-c(names(blloy_tot)[1:4],"X6","age",names(blloy_tot)[7:8])
summary(blloy<-lm(loys~dt*tl+X2+X6+age,
data=blloy_tot))

summary(blabs<-lm(abs_2nd~abs_1st+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),
data=bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20),6]))]
,]))

blabs_2012<-model.frame(blabs)
blabs_2016<-model.frame(blabs)
blabs_2012$dt<-0
blabs_2016$dt<-1

blabs_2012$abs<-blabs_2012$abs_1st
blabs_2016$abs<-blabs_2016$abs_2nd

blabs_tot<-rbind(blabs_2012,blabs_2016)
names(blabs_tot)<-c(names(blabs_tot)[1:4],"X6","age",names(blabs_tot)[7:8])
summary(blabs<-lm(abs~dt*tl+X2+X6+age,
data=blabs_tot))




summary(blabst<-lm(abst_2nd~abst_1st+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(paste(X3))),
data=bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20),6]))]
,]))

blabst_2012<-model.frame(blabst)
blabst_2016<-model.frame(blabst)
blabst_2012$dt<-0
blabst_2016$dt<-1

blabst_2012$abst<-blabst_2012$abst_1st
blabst_2016$abst<-blabst_2016$abst_2nd

blabst_tot<-rbind(blabst_2012,blabst_2016)
names(blabst_tot)<-c(names(blabst_tot)[1:4],"X6","age",names(blabst_tot)[7:8])
summary(blabst<-lm(abst~dt*tl+X2+X6+age,
data=blabst_tot))

summary(blact<-lm(nact2~nact1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),
data=bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[which(nchar(as.character(bl_mps_tot_df[,6]))<20),6]))]
,]))

blact_2012<-model.frame(blact)
blact_2016<-model.frame(blact)
blact_2012$dt<-0
blact_2016$dt<-1

blact_2012$act<-blact_2012$nact1
blact_2016$act<-blact_2016$nact2

blact_tot<-rbind(blact_2012,blact_2016)
names(blact_tot)<-c(names(blact_tot)[1:4],"X6","age",names(blact_tot)[7:8])
summary(blact<-lm(act~dt*tl+X2+X6+age,
data=blact_tot))


save(blabs,file="saved_models/blabs_new.rda")
save(blabst,file="saved_models/blabst_new.rda")
save(blact,file="saved_models/blact_new.rda")
save(blloy,file="saved_models/blloy_new.rda")
stargazer(blloy,blabs,blabst,blact,column.labels=c("loyalty","absences","abstentions","activities"))
stargazer(blloy,column.labels=c("loyalty"))
stargazer(blabs,blabst,blact,column.labels=c("absences","abstentions","activities"))

stargazer(model.frame(blact))
stargazer(model.frame(blabst))
stargazer(model.frame(blabs))
stargazer(model.frame(blloy))

library(stargazer)
stargazer(blloy,column.labels=c("loyalty"), out='regTables/ShirkingBaselland.tex')
stargazer(blabs,blabst,blact,column.labels=c("absences","abstentions","activities"), out = 'regTables/SlackingBaselland.tex')
