# loads MP information Basel-Land
load(file="data/basel_land/bl_mps_tot_August_2018.rda")

table(bl_mps_tot[,6]=="01.07.2003 - ")
bl_mps_tot_df<-data.frame(bl_mps_tot)
bl_mps_tot_df$nact2<-as.numeric(paste(bl_mps_tot[,4]))
bl_mps_tot_df$nact1<-as.numeric(paste(bl_mps_tot[,5]))
bl_mps_tot_df$tl<-as.numeric(bl_mps_tot[,6]=="01.07.2003 - ")

summary(lm(as.numeric(paste(bl_mps_tot[,4]))-as.numeric(paste(bl_mps_tot[,5]))~as.factor(bl_mps_tot[,6]=="01.07.2003 - ")))

table(bl_mps_tot[,6])
-c(grep("2018 -",bl_mps_tot[,6]),
grep("2017 -",bl_mps_tot[,6]),
grep("2016 -",bl_mps_tot[,6]),
grep("- 30.06.2015",bl_mps_tot[,6]))

summary(lm((nact2-nact1)~tl,data=bl_mps_tot_df[-c(grep("2018 -",bl_mps_tot_df[,6]),
grep("2017 -",bl_mps_tot_df[,6]),
grep("2016 -",bl_mps_tot_df[,6]),
grep("- 30.06.2015",bl_mps_tot_df[,6]),which(nchar(bl_mps_tot_df[,6])>20))
,]))
bl_mps_tot_df$inc<-0
bl_mps_tot_df$inc[which(nchar(bl_mps_tot[,6])<20),6]<-1
bl_mps_tot_df$ty<-0
bl_mps_tot_df$ty[grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot_df[,6])]<-1

summary(lm((nact2-nact1)~tl,data=bl_mps_tot_df[bl_mps_tot_df$inc==1&bl_mps_tot_df$ty==0,]))

table(bl_mps_tot_df$inc,bl_mps_tot_df$ty)

tut<-which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]


tut[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]

summary(lm((nact2-nact1)~tl,
data=bl_mps_tot_df[which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]
,]))

#loads corrected vote matrix
load(file="data/basel_land/vm_bl_final.rda")

str(bl_mps_tot_df)
str(vote_mat_f)

substr(colnames(vote_mat_f),1,10)[as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')>"2015-07-30"]

substr(colnames(vote_mat_f),1,10)[as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')<"2015-07-30"&as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')>"2011-07-30"]

for (i in 1:nrow(vote_mat_f)){
bl_mps_tot_df$ty[i]<-
sum(vote_mat_f[i,as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')>"2015-07-30"]=="E",na.rm=T)
bl_mps_tot_df$inc[i]<-
sum(vote_mat_f[i,as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')<"2015-07-30"&as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')>"2011-07-30"]=="E",na.rm=T)}

which(substr(colnames(vote_mat_f),7,10)<2015&substr(colnames(vote_mat_f),7,10)>2011)
which(substr(colnames(vote_mat_f),7,10)>2015)
summary(lm(ty-inc~-1+tl+X2,
data=bl_mps_tot_df[which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]
,]))

list_1st<-which(as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')<"2015-07-30"&as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')>"2011-07-30")

list_2nd<-which(as.Date(substr(colnames(vote_mat_f),1,10),format='%d.%m.%Y')>"2015-07-30")


bl_mps_tot_df$loy_2nd<-NA
bl_mps_tot_df$loy_1st<-NA
bl_mps_tot_df$abs_2nd<-NA
bl_mps_tot_df$abs_1st<-NA
bl_mps_tot_df$abs_2nd<-NA
bl_mps_tot_df$abst_1st<-NA
bl_mps_tot_df$abst_2nd<-NA
for (j in 1: nrow(vote_mat_f)){
loy=0
nloy=0
abs=0
abst=0
for (i in 1:length(list_2nd)){
if(is.na(vote_mat_f[j,list_2nd[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="J",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="N",na.rm=T)&
vote_mat_f[j,list_2nd[i]]=="J") loy=loy+1
if(is.na(vote_mat_f[j,list_2nd[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="J",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="N",na.rm=T)&
vote_mat_f[j,list_2nd[i]]=="N") nloy=nloy+1
if(is.na(vote_mat_f[j,list_2nd[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="N",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="J",na.rm=T)&
vote_mat_f[j,list_2nd[i]]=="J") nloy=nloy+1
if(is.na(vote_mat_f[j,list_2nd[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="N",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_2nd[i]]=="J",na.rm=T)&
vote_mat_f[j,list_2nd[i]]=="N") loy=loy+1
if(is.na(vote_mat_f[j,list_2nd[i]])==F&vote_mat_f[j,list_2nd[i]]=="E") abst=abst+1
if(is.na(vote_mat_f[j,list_2nd[i]])==T)abs=abs+1}

if((loy+nloy)>0)bl_mps_tot_df$loy_2nd[j]<-loy/(loy+nloy)
bl_mps_tot_df$abs_2nd[j]<-abs/(length(list_2nd))
bl_mps_tot_df$abst_2nd[j]<-abst/(length(list_2nd))
}

for (j in 1: nrow(vote_mat_f)){
loy=0
nloy=0
abs=0
abst=0
for (i in 1:length(list_1st)){
if(is.na(vote_mat_f[j,list_1st[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="J",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="N",na.rm=T)&
vote_mat_f[j,list_1st[i]]=="J") loy=loy+1
if(is.na(vote_mat_f[j,list_1st[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="J",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="N",na.rm=T)&
vote_mat_f[j,list_1st[i]]=="N") nloy=nloy+1
if(is.na(vote_mat_f[j,list_1st[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="N",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="J",na.rm=T)&
vote_mat_f[j,list_1st[i]]=="J") nloy=nloy+1
if(is.na(vote_mat_f[j,list_1st[i]])==F) if(sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="N",na.rm=T)>
sum(vote_mat_f[bl_mps_tot_df[j,2]==bl_mps_tot_df[,2],list_1st[i]]=="J",na.rm=T)&
vote_mat_f[j,list_1st[i]]=="N") loy=loy+1
if(is.na(vote_mat_f[j,list_1st[i]])==F&vote_mat_f[j,list_1st[i]]=="E") abst=abst+1
if(is.na(vote_mat_f[j,list_1st[i]])==T)abs=abs+1}

if((loy+nloy)>0)bl_mps_tot_df$loy_1st[j]<-loy/(loy+nloy)
bl_mps_tot_df$abs_1st[j]<-abs/(length(list_1st))
bl_mps_tot_df$abst_1st[j]<-abst/(length(list_1st))
}
names(bl_mps_tot_df)
summary(blloy<-lm(loy_2nd-loy_1st~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),

data=bl_mps_tot_df[which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]
&bl_mps_tot_df$X2!="Parteilos",]))


summary(blabs<-lm(abs_2nd-abs_1st~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),

data=bl_mps_tot_df[which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]
,]))


summary(blabst<-lm(abst_2nd-abst_1st~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),

data=bl_mps_tot_df[which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]
,]))

summary(blact<-lm(nact2-nact1~-1+tl+X2+as.factor(X6=="01.07.2011 - ")+I(2015-as.numeric(X3)),
data=bl_mps_tot_df[which(nchar(bl_mps_tot[,6])<20)[-c(grep("2018|2017|2016|2015|2014|2013|2012",bl_mps_tot[which(nchar(bl_mps_tot[,6])<20),6]))]
,]))

save(blabs,file="saved_models/blabs.rda")
save(blabst,file="saved_models/blabst.rda")
save(blact,file="saved_models/blact.rda")
save(blloy,file="saved_models/blloy.rda")

library(stargazer)
stargazer(blloy,column.labels=c("loyalty"), out='regTables/ShirkingBaselland.tex')
stargazer(blabs,blabst,blact,column.labels=c("absences","abstentions","activities"), out = 'regTables/SlackingBaselland.tex')
