### Analyses for Basel-Stadt
load(file="saved_models/bs_total_data.rda")

summary(bs_act<-lm((act_2017-act_2013)~tl+Party+age_2016+reelec,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F,]))
summary(reg_abs<-lm(-share_absent_2012+share_absent~(tl)+Party+age_2016+reelec,,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F,]))
summary(reg_abst<-lm(-share_abstain_2012+share_abstain~(tl)+Party+age_2016+reelec,,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F,]))
summary(reg_ly<-lm(-loy_2012/(loy_2012+nloy_2012)+loy/(loy+nloy)~(tl)+Party+age_2016+reelec,,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F&bs_gr_krs_vt$Party!="fraktionslos",]))
stargazer(reg_ly)
stargazer(reg_abs,reg_abst,bs_act)
stargazer(reg_ly)

stargazer(reg_abs,reg_abst,bs_act)
stargazer(reg_ly)

save(reg_ly,file="saved_models/bs_reg_ly.rda")
save(reg_abst,file="saved_models/bs_reg_abst.rda")
save(reg_abs,file="saved_models/bs_reg_abs.rda")
save(bs_act,file="saved_models/bs_reg_act.rda")


summary(bs_act<-lm((act_2017)~act_2013+tl+Party+age_2016+reelec,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F,]))

bs_act_2013<-model.frame(bs_act)
bs_act_2017<-model.frame(bs_act)
bs_act_2013$dt<-0
bs_act_2017$dt<-1

bs_act_2013$act<-bs_act_2013$act_2013
bs_act_2017$act<-bs_act_2017$"(act_2017)"

bs_act_tot<-rbind(bs_act_2013,bs_act_2017)

summary(bs_act<-lm((act)~dt*tl+Party+age_2016+reelec,
 data=bs_act_tot))

summary(reg_abs<-lm(-share_absent_2012~share_absent+(tl)+Party+age_2016+reelec,,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F,]))

bs_reg_abs_2013<-model.frame(reg_abs)
bs_reg_abs_2017<-model.frame(reg_abs)
bs_reg_abs_2013$dt<-0
bs_reg_abs_2017$dt<-1

bs_reg_abs_2013$abs<-bs_reg_abs_2013$"-share_absent_2012"
bs_reg_abs_2017$abs<-bs_reg_abs_2017$share_absent

bs_reg_abs_tot<-rbind(bs_reg_abs_2013,bs_reg_abs_2017)

summary(reg_abs<-lm(abs~dt*tl+Party+age_2016+reelec,
 data=bs_reg_abs_tot))

summary(reg_abst<-lm(-share_abstain_2012~share_abstain+(tl)+Party+age_2016+reelec,,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F,]))

bs_reg_abst_2013<-model.frame(reg_abst)
bs_reg_abst_2017<-model.frame(reg_abst)
bs_reg_abst_2013$dt<-0
bs_reg_abst_2017$dt<-1

bs_reg_abst_2013$abst<-bs_reg_abst_2013$"-share_abstain_2012"
bs_reg_abst_2017$abst<-bs_reg_abst_2017$share_abstain

bs_reg_abst_tot<-rbind(bs_reg_abst_2013,bs_reg_abst_2017)

summary(reg_abst<-lm(abst~dt*tl+Party+age_2016+reelec,
 data=bs_reg_abst_tot))

summary(reg_ly<-lm(+loy/(loy+nloy)~(tl)+I(loy_2012/(loy_2012+nloy_2012))+Party+age_2016+reelec,,
 data=bs_gr_krs_vt[is.na(bs_gr_krs_vt$year.x)==F&is.na(bs_gr_krs_vt$year.y)==F&bs_gr_krs_vt$Party!="fraktionslos",]))

bs_reg_ly_2013<-model.frame(reg_ly)
bs_reg_ly_2017<-model.frame(reg_ly)
bs_reg_ly_2013$dt<-0
bs_reg_ly_2017$dt<-1

bs_reg_ly_2013$loys<-bs_reg_ly_2013$"I(loy_2012/(loy_2012 + nloy_2012))"
bs_reg_ly_2017$loys<-bs_reg_ly_2017$"+loy/(loy + nloy)"

bs_reg_ly_tot<-rbind(bs_reg_ly_2013,bs_reg_ly_2017)

summary(reg_ly<-lm(loys~dt*tl+Party+age_2016+reelec,
 data=bs_reg_ly_tot))

stargazer(reg_abs,reg_abst,bs_act)
stargazer(reg_ly)
save(reg_ly,file="saved_models/bs_reg_ly_new.rda")
save(reg_abst,file="saved_models/bs_reg_abst_new.rda")
save(reg_abs,file="saved_models/bs_reg_abs_new.rda")
save(bs_act,file="saved_models/bs_reg_act_new.rda")


