#### Analyses of ideological distances CH national parliament
load(file="saved_models/ch_dis_data.rda")

d4748$age48 <- (2003-as.numeric(substr(paste(d4748$pers_id[]),(nchar(paste(d4748$pers_id[]))-3),nchar(paste(d4748$pers_id[])))))

summary(r47<-lm(partydis47~-1+tl48+as.factor(Fraktion)+Rat.y+cohort.y+age.y,data=d4748))
summary(r48<-lm(partydis48~-1+tl48+as.factor(group)+Rat.y+cohort.y+age.y,data=d4748))

summary(r4748<-lm(partydis48-partydis47~-1+tl48+as.factor(group)+Rat.y+cohort.y+age.y,data=d4748))

summary(r48a<-lm(partydis48~-1+tl48+as.factor(group)+Rat.y+cohort.y+age.y,data=d4748[rownames(model.frame(r4748)),]))

stargazer(r47,r48,r48a,r4748,digits=3)

save(r4748,file="saved_models/ch_partydis_new.rda")


summary(r48c<-lm(cantdis48~-1+tl48
                 +as.factor(group)+Rat.y+cohort.y+age.y,data=d4748))
summary(r47c<-lm(cantdis47~-1+tl48                 +as.factor(Fraktion)+Rat.x+cohort.y+age.y,data=d4748))
summary(r4748c<-lm(cantdis48-cantdis47~-1+tl48
+as.factor(group)+Rat.y+cohort.y+age.y,data=d4748))
summary(r48ca<-lm(cantdis48~-1+tl48              +as.factor(group)+Rat.y+cohort.y+age.y,data=d4748[rownames(model.frame(r4748c))     ,]))
summary(r47ca<-lm(cantdis47~-1+tl48                 +as.factor(Fraktion)+Rat.x+cohort.y+age.y,data=d4748[rownames(model.frame(r4748c))  ,]))
                                            
stargazer(r47c,r48c,r48ca,r4748c,digits=3)

save(r4748c,file="saved_models/ch_cantdis_new.rda")


d4748$tl48<-0
d4748$tl48[d4748$TermLimit.y==1]<-1

summary(r47a<-lm(partydis47~-1+tl48+as.factor(Fraktion)+Rat.x+seniority47.x+age47.x,data=d4748))


#dtot<-rbind(dch47,dch48)

r47d<-model.frame(r47)
r48d<-model.frame(r48)
r47d$t<-0
r48d$t<-1
names(r48d)<-names(r47d)
rtot<-rbind(r47d,r48d)
names(rtot)
names(rtot)[3]<-"Fraktion"
summary(rtotr<-lm(partydis47~-1+tl48*t+as.factor(Fraktion)+Rat.y+cohort.y+age.y+t,data=rtot))

r47cd<-model.frame(r47c)
r48cd<-model.frame(r48c)
r47cd$t<-0
r48cd$t<-1
names(r48cd)<-names(r47cd)
rctot<-rbind(r47cd,r48cd)
names(rctot)
names(rctot)[3]<-"Fraktion"
summary(rtotcr<-lm(cantdis47~-1+tl48*t+as.factor(Fraktion)+Rat.x+cohort.y+age.y+t,data=rctot))

stargazer(rtotr,rtotcr,digits=3)

save(rtotcr,file="saved_models/ch_cantdis_newnew.rda")

save(rtotr,file="saved_models/ch_partydis_newnew.rda")

#Analyses of activities

load(file="saved_models/ch_act_data.rda")

summary(r4act<-lm(I(act48-act47)~-1+I(tl48)+
                  +as.factor(group)+cohort.y+age.y+Rat.y,data=d4748p))

stargazer(r4act)
save(r4act,file="saved_models/ch_r4act_new.rda")

summary(r4act47<-lm(act47~-1+tl48+
                  +as.factor(group)+cohort.y+age.y+Rat.y,data=d4748p))

summary(r4act48<-lm(act48~-1+tl48+
                  +as.factor(group)+cohort.y+age.y+Rat.y,data=d4748p))

r47a<-model.frame(r4act47)
r48a<-model.frame(r4act48)
r47a$t<-0
r48a$t<-1
names(r47a)[3]<-"group"
names(r48a)<-names(r47a)
rtota<-rbind(r47a,r48a)
summary(r4acta<-lm(act47~-1+tl48*t+
                  +as.factor(group)+cohort.y+age.y+Rat.y,data=rtota))


stargazer(r4acta)
save(r4acta,file="saved_models/ch_r4act_newnew.rda")

## upper house based on voting

load(file="saved_models/ch_sr_data.rda")


summary(loyr<-lm(I(tloy.y-tloy.x)~-1+tl+FactionMembershipShortnameDE.y+seniortity_years_startTerm.y+age.y,data=mps_comb))

summary(absr<-lm((abs.y-abs.x)~-1+tl+FactionMembershipShortnameDE.y+seniortity_years_startTerm.y+age.y,data=mps_comb))

summary(abstr<-lm((abst.y-abst.x)~-1+tl+FactionMembershipShortnameDE.y+seniortity_years_startTerm.y+age.y,data=mps_comb))

save(absr,file="saved_models/ch_sr_abs.rda")

save(abstr,file="saved_models/ch_sr_abst.rda")

save(loyr,file="saved_models/ch_sr_loy.rda")

stargazer(loyr,absr,abstr)

#alternative models
load(file="saved_models/ch_sr_data_new.rda")

summary(loyr<-lm(tloy~-1+t*tl+FactionMembershipShortnameDE+
 age+seniortity_years_startTerm
 ,data=mps_tot[mps_tot$FactionMembershipShortnameDE!="Fraktion BD",]))

summary(absr<-lm(abs~-1+t*tl+FactionMembershipShortnameDE+
 age+seniortity_years_startTerm
 ,data=mps_tot[mps_tot$FactionMembershipShortnameDE!="Fraktion BD",]))
#,data=mps_tot))

summary(abstr<-lm(abst~-1+t*tl+FactionMembershipShortnameDE+
 age+seniortity_years_startTerm
 ,data=mps_tot[mps_tot$FactionMembershipShortnameDE!="Fraktion BD",]))
#,data=mps_tot))


save(absr,file="saved_models/ch_sr_abs_new.rda")

save(abstr,file="saved_models/ch_sr_abst_new.rda")

save(loyr,file="saved_models/ch_sr_loy_new.rda")


stargazer(loyr,absr,abstr,covariate.labels=c("time","term-limited",#"BD",
"C","G","GL","RL","S","V",
"age",#"gender",
"seniority","term-limited x time"))

stargazer(model.frame(loyr),covariate.labels=c("loyalty","time","term-limited",
"age",#"gender",
 "seniority"))
stargazer(model.frame(absr),covariate.labels=c("absences","time","term-limited",
"age",#"gender",
 "seniority"))
stargazer(model.frame(abstr),covariate.labels=c("abstentions","time","term-limited",
"age",#"gender",
 "seniority"))
