#Replication material for Frech, Goet, and Hug, 'Shirking and Slacking in Parliament'
#First version: 25th February 2019
#This version: 6th February 2019

# dependencies (please uncomment the lines below to install the required R dependencies)
# dependencies <- c('ggplot2',
# 'bcp',
# 'strucchange',
# 'foreign',
# 'optimx',
# 'lme4',
# 'grid',
# 'stargazer',
# 'spduration',
# 'survival',
# 'ggrepel',
# 'arm')

# lapply(dependencies,function(x) install.packages(x))

######
# Mixed generalised linear model (binomial)
######
Sys.setlocale("LC_MESSAGES", 'en_GB.UTF-8')
scriptPath <- rstudioapi::getSourceEditorContext()$path
scriptPath <- gsub('replicate.R','',scriptPath)
setwd(scriptPath)

# set up log file
logfile_name <- gsub('-| |:','_',paste('sasip_logfile_',Sys.time(),'.log',sep=''))
log_file <- file(logfile_name)
cat(paste('Starting replication for main analysis (start time: ',Sys.time(),')',sep=''),file=log_file)
close(log_file)

benchmark <- data.frame(script_name = character(),
  execution_time = numeric())

#execution function
execute_script <- function(benchmark,info_message,script_name,type='R',input_params=NULL,numCores=NULL){
  clean_workspace()
  message(info_message)
  log_file <- file(logfile_name, open = 'a')
  log_m <- paste('\n\nExecuting ',script_name,' script (start time: ',Sys.time(),')',sep='')
  cat(log_m, file = log_file,append = TRUE)
  close(log_file)
  
  message(log_m)

  if(type=='R'){
    execution_time <- round(system.time({source(script_name)})[3]/60,digits=2)
  }else{
    execution_time <- round(system.time({system(paste('python3',script_name,input_params,sep=' '))})[3]/60,digits=2)  
  }

  log_file <- file(logfile_name, open = 'a')
  cat(paste('\n',script_name, ' script successfully run. Execution time: ',execution_time,' minutes',sep=''), file = log_file,append = TRUE)
  close(log_file)
  
  message(paste('\n',script_name, ' script successfully run. Execution time: ',execution_time,' minutes',sep=''))
  
  benchmark <- rbind(benchmark,data.frame(script_name = script_name,
  execution_time = execution_time))
  
  return(benchmark)
}

#clear function 
clean_workspace <- function(){
  rm(list = setdiff(ls(), c('logfile_name','dataPath','benchmark')))
  Sys.sleep(10)
  gc()
}
# start replication
log_file <- file(logfile_name, open = 'a')
cat(paste('Starting replication of main analysis (start time: ',Sys.time(),')',sep=''),file=log_file)
close(log_file)

# Speech analysis
info_message <- 'Generating estimates for speech analyses, upper- and lower- House.'
script_name <- 'dependencies/speech_analysis.R'

execute_script(benchmark,info_message,script_name)
clean_workspace()


# Votes analysis
info_message <- 'Generating estimates for votes analyses, upper- and lower- House.'
script_name <- 'dependencies/votes_analysis.R'

execute_script(benchmark,info_message,script_name)
clean_workspace()

# Generate ECDF plot
info_message <- 'Generating ECDF plot for on-line Appendix (figure 2)'

script_name <- 'dependencies/ECDF_plots.R'

execute_script(benchmark,info_message,script_name)
clean_workspace()


# Replicate analyses for Basel-Land
info_message <- 'Replicating analyses for Basel-Land'
script_name <- 'dependencies/sasip_bl.r'

execute_script(benchmark,info_message,script_name)
clean_workspace()


# Replicate analyses for Basel-Stadt
info_message <- 'Replicating analyses for Basel-Stadt'
script_name <- 'dependencies/sasip_bs.r'

execute_script(benchmark,info_message,script_name)
clean_workspace()


# Replicate analyses for shirking from cantons at national level
info_message <- 'Replicating analyses for national level'

script_name <- 'dependencies/sasip_ch.R'

execute_script(benchmark,info_message,script_name)
clean_workspace()

# Generate coefficient plots
info_message <- 'Generating coefficient plots'

script_name <- 'dependencies/combinedPlot_newsh.R'

execute_script(benchmark,info_message,script_name)
clean_workspace()
