// Replication Cederman, L. E., Hug, S., Schädel, A., & Wucherpfennig, J. (2015). "Territorial autonomy in the shadow of conflict: Too little, too late?." American Political Science Review 109(2): 354-370.

cd "/Users/larsc/Dropbox/TooLittleTooLate/Replication Data APSR/replication final"
clear
clear matrix
set mem 500m
use replication_tltl, clear



//PAPER

//TABLE 3

// Model 1: Naive model
logit onset_do_terr_flag egip status_autonomy warhist1 b b2 excl_groups_count federal ln_rgdppc_lag ln_pop c_incidence_flagl pys_family inc_spline*  if isrelevant == 1 & status_monop == 0 & status_dominant==0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1, nolog cluster(cowcode)
test egip = status_autonomy // H1
// Model 2: Differentiating between pre and post conflict effects
logit onset_do_terr_flag warhist1 egip status_autonomy egipXwarhist autonomyXwarhist b b2 excl_groups_count federal ln_rgdppc_lag ln_pop c_incidence_flagl pys_family inc_spline*  if isrelevant == 1 & status_monop == 0 & status_dominant==0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1, nolog cluster(cowcode)
test egip = status_autonomy // H1
test egip + egipXwarhist = 0
test status_autonomy + autonomyXwarhist = 0
test egip + egipXwarhist =  status_autonomy + autonomyXwarhist
// Model 3: Differentiating between pre and post conflict effects while splitting egips
logit onset_do_terr_flag warhist1 egip_aut egip_naut status_autonomy egip_autXwarhist egip_nautXwarhist autonomyXwarhist b b2 excl_groups_count federal ln_rgdppc_lag ln_pop c_incidence_flagl pys_family inc_spline*  if isrelevant == 1 & status_monop == 0 & status_dominant==0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1, nolog cluster(cowcode)
test egip_aut + egip_autXwarhist = 0
test egip_aut + egip_autXwarhist = status_autonomy + autonomyXwarhist
// Model 4: Effect of centralization through revocation of autonomy
logit onset_do_terr_flag warhist1 egip_aut egip_naut status_autonomy egip_autXwarhist egip_nautXwarhist autonomyXwarhist cent_aut2 other_downgraded2 b b2 excl_groups_count federal ln_rgdppc_lag ln_pop c_incidence_flagl pys_family inc_spline*  if isrelevant == 1 & status_monop == 0 & status_dominant==0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1, nolog cluster(cowcode)


//TABLE 4

// Model 5: Explaining autonomy. Naive model with EGIPs
probit aut britishcol_flag lnasize lnasizeXbrit b b2 epr_elf ln_rgdppc_lag ln_pop pys_family inc_spline* if isrelevant == 1 & status_monop == 0 & status_dominant == 0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1 & brfr_col==1, nolog cluster(cowcode)
// Model 6: Explaining conflict. Naive model with EGIPs
probit onset_do_terr_flag aut britishcol_flag lnasize b b2 epr_elf ln_rgdppc_lag ln_pop pys_family inc_spline* if isrelevant == 1 & status_monop == 0 & status_dominant == 0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1 & brfr_col==1, nolog cluster(cowcode)
// Model 7: Endogenous model with EGIPs
biprobit (onset_do_terr_flag = aut britishcol_flag lnasize b b2 epr_elf ln_rgdppc_lag ln_pop pys_family inc_spline*) (aut = britishcol_flag lnasize lnasizeXbrit b b2 epr_elf ln_rgdppc_lag ln_pop pys_family inc_spline*) if isrelevant == 1 & status_monop == 0 & status_dominant == 0 & !(pys_family==0 & family_warhist>0) & terr_relevant==1 & brfr_col==1, nolog cluster(cowcode)


