%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
%  maitrise.cls : Un fichier class pour un travail de maitrise            %
%                 Universit de Genve, Facult des Sciences              %
%                 Section de mathmatiques                                %
%                                                                         %
%                 Version 2.0,  29/04/2008 by Martin Gander               %
%                 (Version 1.0 by Julio Rodriguez in 2007)                %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{master}

% All options are passed to the article class.

\LoadClassWithOptions{article}

% use standard language package for french

\usepackage[french]{babel}
\usepackage[T1]{fontenc}

% use standard graphics and math packages

\usepackage{amsmath,amssymb}
\usepackage{psfrag}
\usepackage{graphicx}

% modify page sizes and indentation

\oddsidemargin 0in \evensidemargin 0in
\topmargin -25pt \headheight 9pt \headsep 25pt 
\setlength{\textheight}{235mm}
\setlength{\textwidth}{155mm}

% provide standard mathematics environments

\newtheorem{theorem}{\bf Th\'eor\`eme}[section]
\newtheorem{lemma}[theorem]{\bf Lemme}
\newtheorem{corollary}[theorem]{\bf Corollaire}
\newtheorem{proposition}[theorem]{\bf Proposition}
\newtheorem{definition}{\bf D\'efinition}[section]
\newtheorem{algorithm}{\bf Algorithme}[section]

\newenvironment{proof}{\noindent{\bf D\'emonstration\ }}{\QED\\}
\newcommand{\QED}{\hspace*{\fill}\rule{2.5mm}{2.5mm}}

\newtheorem{remark}{\bf  Remarque}[section]
\newtheorem{problem}{\bf Probl\`eme}[section]
\newtheorem{example}{\bf Exemple}[section]

% Variables for the titlepage

\newcommand{\Supervisor}[1]{\gdef\@Supervisor{#1}}

\renewcommand{\maketitle}{
    \thispagestyle{empty}
    \setcounter{page}{0}
    \noindent\large UNIVERSIT\'E DE GEN\`EVE \hfill FACULT\'E DES SCIENCES \\
    Section de math\'ematiques

    \hrule
    \vfill
    \begin{center}
    {\Large\bf\@title}
    \vfill

    {\large\rm\ {\@author} }
    \vfill

    {\large Travail de Ma\^itrise sous la supervision de} \\
    {\large { \@Supervisor } } 
    \vfill

    {\footnotesize
    Atelier de reproduction de la Section de physique \\
    Gen\`eve, \ \@date \\[-2mm]}
    \hrulefill

    \end{center}
    \newpage }


\@addtoreset{equation}{section}   % Makes \section reset 'equation' counter.
\def\theequation{\thesection.\arabic{equation}}

\@addtoreset{theorem}{section}
\def\thetheorem{\thesection.\@arabic\c@theorem}
\def\thelemma{\thesection.\@arabic\c@theorem}
\def\thecorollary{\thecorollary.\@arabic\c@theorem}
\def\theproposition{\theproposition.\@arabic\c@theorem}

\@addtoreset{figure}{section}
\def\thefigure{\thesection.\@arabic\c@figure}

\@addtoreset{table}{section}
\def\thetable{\thesection.\@arabic\c@table}
