%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
%  masters.cls : A class file for a master thesis                         %
%                Universit de Genve, Facult des Sciences               %
%                Section de mathmatiques                                 %
%                                                                         %
%                Version 2.0,  29/04/2008 by Martin Gander                %
%               (Version 1.0 by Julio Rodriguez in 2007)                  %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{master}

% All options are passed to the article class.

\LoadClassWithOptions{article}

% use standard graphics and math packages

\usepackage{amsmath,amssymb}
\usepackage{psfrag}
\usepackage{graphicx}

%modify page sizes and indentation

\oddsidemargin 0in \evensidemargin 0in
\topmargin -25pt \headheight 9pt \headsep 25pt 
\setlength{\textheight}{235mm}
\setlength{\textwidth}{155mm}

% provide standard mathematics environments

\newtheorem{theorem}{\bf Theorem}[section]
\newtheorem{lemma}[theorem]{\bf Lemma}
\newtheorem{corollary}[theorem]{\bf Corollary}
\newtheorem{proposition}[theorem]{\bf Proposition}
\newtheorem{definition}{\bf Definition}[section]
\newtheorem{algorithm}{\bf Algorithm}[section]
\newenvironment{proof}{\noindent{\bf Proof\ }}{\QED\\}
\newcommand{\QED}{\hspace*{\fill}\rule{2.5mm}{2.5mm}}

\newtheorem{remark}{\bf  Remark}[section]
\newtheorem{problem}{\bf Problem}[section]
\newtheorem{example}{\bf Example}[section]

% Variables for the titlepage

\newcommand{\Supervisor}[1]{\gdef\@Supervisor{#1}}

\renewcommand{\maketitle}{
    \thispagestyle{empty}
    \setcounter{page}{0}
    \noindent\large UNIVERSIT\'E DE GEN\`EVE \hfill FACULT\'E DES SCIENCES \\
    Section de math\'ematiques

    \hrule
    \vfill
    \begin{center}
    {\Large\bf\@title}
    \vfill

    {\large\rm\ {\@author} }
    \vfill

    {\large Master thesis under the supervision of} \\
    {\large { \@Supervisor } } 
    \vfill

    {\footnotesize
    Atelier de reproduction de la Section de physique \\
    Geneva, \ \@date \\[-2mm]}
    \hrulefill

    \end{center}
    \newpage }

\@addtoreset{equation}{section}   % Makes \section reset 'equation' counter.
\def\theequation{\thesection.\arabic{equation}}

\@addtoreset{theorem}{section}
\def\thetheorem{\thesection.\@arabic\c@theorem}
\def\thelemma{\thesection.\@arabic\c@theorem}
\def\thecorollary{\thecorollary.\@arabic\c@theorem}
\def\theproposition{\theproposition.\@arabic\c@theorem}

\@addtoreset{figure}{section}
\def\thefigure{\thesection.\@arabic\c@figure}

\@addtoreset{table}{section}
\def\thetable{\thesection.\@arabic\c@table}
