C
C   this driver uses the GGG graphics routines
C   if you use your own graphics routines, please, uncomment the
C   calls to begin_ggg, scale_char,...
C
      include 'method.f'
      PARAMETER (ND=36)
      IMPLICIT REAL*8 (D)
      DIMENSION DY(ND),METH(10),DPAR(10)
      EXTERNAL DEQUA
      COMMON /INTERP/DHAMEX,DANGEX(3),XDES(5000),YDES(5000),AN,IST
      COMMON /DESTAT/YMEAN(5000),YDEVI(5000)
      common /COUNT/NFCN,NPROB
      common/sizes/adim(4)
      data adim/10.5,4.0,0.,0.5/
C
      NPROB=4
      NPER=100
      NS=6
      IOUT=1      
      CALL PRDATA (NPROB,NEQU,NPER,NS,NN,DHH,DX,DXEND,DY,ND,DPAR)
c
      call begin_ggg('driver')
      call scale_char(0.80)
      call thick_pixel(3)
      xmin=0.
      xmax=dxend
      ymin=-3.99
      ymax=-ymin
      call masog(xmin,xmax,ymin,ymax)
      call framg
      call axex(0.,ymin,xmin,xmax,300000.,3)
C      call label_x(0.,ymin,xmin,xmax,300000.,0)
      KDEL=3
      KGRAD=1
      call axey(0.,0.,ymin,ymax,1.,10)
      call label_y(0.,0.,ymin,ymax,1.,0)
      call thick_pixel(2)
c
       IY=1757
       DO I=1,5000
         YMEAN(I)=0.
         YDEVI(I)=0.
       END DO
C --- NSTAT is the number of calls to the RK method (random initial values)
       NSTAT=5
       DO ISTAT=1,NSTAT
         METH(1)=NS
C        METH(1) = NS, NUMBER OF STAGES OF THE METHOD
         METH(2)=0
         METH(3)=0
         METH(4)=0
         CALL PRDATA (NPROB,NEQU,NPER,NS,NN,DHH,DX,DXEND,DY,ND,DPAR)
         CALL CHDATA (NEQU,DY)
         write (6,*) ' '
         write (6,*) ' problem ',nprob,istat
c
         DO I=1,NEQU/2
           DY(I)=DY(I)+(URAND(IY)-0.5)*1.0D-12
         END DO
         CALL DHAMIL(NEQU,DY,DHAMEX)
         CALL DMOMEN(NEQU,DY,DANGEX)
c
         IST=0
         AN=2.
         NFCN=0
         call cpu_time (time0)
         CALL GRKAAD(NEQU,DEQUA,NN*NPER,DX,DY,DXEND,METH,IOUT,DPAR)
         CALL cpu_time(time1)
         WRITE (6,*) '  NFCN  ',NFCN
         write(6,*)'  method, order = ',2*ns
         write(6,*)'   nn, h, nper = ',nn,dhh,nper
         write(6,*)'    cpu time ',time1-time0
         call color('blue')
         do i=1,ist
            ydes(i)=ydes(i)*1.0d15
         end do
         CALL LING(XDES,YDES,ist)
      END DO
C
      DO I=1,IST
         YMEAN(I)=YMEAN(I)/NSTAT
         YDEVI(I)=SQRT(YDEVI(I)/NSTAT-YMEAN(I)**2)*1.0D15
         YMEAN(I)=YMEAN(I)*1.0D15
      END DO
      call thick_pixel(10)
      CALL COLOR ('red')
      CALL LING(XDES,YMEAN,ist)
      DO I=1,IST
         YDES(I)=YMEAN(I)+YDEVI(I)
      END DO
      CALL LING(XDES,YDES,ist)
      DO I=1,IST
         YDES(I)=YMEAN(I)-YDEVI(I)
      END DO
      CALL LING(XDES,YDES,ist)
      write (6,*) ymean(ist),ydevi(ist),ist
c     
      call greater_boundingbox (1.,0.1,0.5,0.)
      call end_ggg
      STOP
      END
C
      SUBROUTINE PRDATA (NPROB,NEQU,NPER,NS,NN,DHH,DX,DXEND,DY,ND,DPAR)
      IMPLICIT REAL*8 (D)
      DIMENSION DY(ND),DPAR(10)
      IF (NPROB.EQ.1) THEN         ! KEPLER
         NEQU=4
         IF (NS.EQ.2) NN=38000
         IF (NS.EQ.3) NN=1500
         IF (NS.EQ.4) NN=250
         IF (NS.EQ.6) NN=46
         DPI=4*ATAN(1.0D0)
         DHH=2*DPI/NN
         DX=0.D0
         DXEND=2*DPI*NPER
         DEE=0.3D0
         DY(1)=1.D0-DEE
         DY(2)=0.D0
         DY(3)=0.D0
         DY(4)=SQRT((1.D0+DEE)/(1.D0-DEE))
         DPAR(1)=8.0E-15
      END IF
      IF (NPROB.EQ.2) THEN             ! HENON-HEILES
         NEQU=4
         IF (NS.EQ.2) NN=22000
         IF (NS.EQ.3) NN=800
         IF (NS.EQ.4) NN=140
         IF (NS.EQ.6) NN=24
         DPI=4*ATAN(1.0D0)
         DHH=2*DPI/NN
         DX=0.D0
         DXEND=2*DPI*NPER
         DHAM0=1.D0/8.D0
         DY(1)=0.D0
         DY(2)=0.3D0
         DY(4)=0.2D0
         DUU0=(DY(1)**2+DY(2)**2)/2 + DY(1)**2*DY(2) - DY(2)**3/3
         DY(3)=SQRT(2*DHAM0-2*DUU0-DY(4)**2)
         DPAR(1)=2.0E-16
      END IF
      IF (NPROB.EQ.4) THEN      ! OUTER SOLAR SYSTEM
         NEQU=36
         IF (NS.EQ.2) NN=22000
         IF (NS.EQ.3) NN=800
         IF (NS.EQ.4) NN=140
         IF (NS.EQ.6) NN=60
         DHH=1.0D4/NN
         DX=0.0D0
         DXEND=1.0D4*NPER
         DY(1)=-3.5023653D0
         DY(2)=-3.8169847D0
         DY(3)=-1.5507963D0
         DY(4)=9.0755314D0
         DY(5)=-3.0458353D0
         DY(6)=-1.6483708D0
         DY(7)=8.3101420D0
         DY(8)=-16.2901086D0
         DY(9)=-7.2521278D0
         DY(10)=11.4707666D0
         DY(11)=-25.7294829D0
         DY(12)=-10.8169456D0
         DY(13)=-15.5387357D0
         DY(14)=-25.2225594D0
         DY(15)=-3.1902382D0
         DY(16)=0.0D0
         DY(17)=0.0D0
         DY(18)=0.0D0
         DY(19)=0.00565429D0
         DY(20)=-0.00412490D0
         DY(21)=-0.00190589D0
         DY(22)=0.00168318D0
         DY(23)=0.00483525D0
         DY(24)=0.00192462D0
         DY(25)=0.00354178D0
         DY(26)=0.00137102D0
         DY(27)=0.00055029D0
         DY(28)=0.00288930D0
         DY(29)=0.00114527D0
         DY(30)=0.00039677D0
         DY(31)=0.00276725D0
         DY(32)=-0.00170702D0
         DY(33)=-0.00136504D0
         DY(34)=0.0D0
         DY(35)=0.0D0
         DY(36)=0.0D0
         DPAR(1)=2.0D-21
      END IF
      RETURN
      END
C
      SUBROUTINE SOLFID (NR,XOLD,X,Y,N,IRTRN)
      PARAMETER (NSD=11,NMAX=30)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y(N),DANG(3)
      REAL*4 XDES,YDES,AN,HAMEX,YMEAN,YDEVI
      REAL*4 ERRA1,ERRA2,ERRA3
      REAL*16 QHAMEX
      COMMON /INTERP/DHAMEX,DANGEX(3),XDES(5000),YDES(5000),AN,IST
      COMMON /DESTAT/YMEAN(5000),YDEVI(5000)
        IF (MOD(NR,51).EQ.0) THEN
           CALL DHAMIL(N,Y,DHAM)
           CALL DMOMEN(N,Y,DANG)
           ERRH=(DHAM-DHAMEX)/DHAMEX
           ERRA1=(DANG(1)-DANGEX(1))/DANGEX(1)
           ERRA2=(DANG(2)-DANGEX(2))/DANGEX(2)
           ERRA3=(DANG(3)-DANGEX(3))/DANGEX(3)
c           write (6,*) '  error ',nr,ERRH,ERRA1,ERRA2,ERRA3
           ist=ist+1
           XDES(ist)=X
           YDES(ist)=ERRH
           YMEAN(ist)=YMEAN(ist)+ERRH
           YDEVI(ist)=YDEVI(ist)+ERRH**2
        END IF
      RETURN
      END
c
        SUBROUTINE DEQUA(N,X,Y,F)
        IMPLICIT REAL*8 (A-H,O-Z) 
        REAL*8  D(6,6),M(6)
        DIMENSION Y(N),F(N)
        common /COUNT/NFCN,NPROB
          nfcn=nfcn+1
        IF (NPROB.EQ.1) THEN
           f(1)=y(3)
           f(2)=y(4)
           rad=y(1)*y(1)+y(2)*y(2)
           rad=rad*sqrt(rad)
           f(3)=-y(1)/rad
           f(4)=-y(2)/rad
        END IF
        IF (NPROB.EQ.2) THEN
           f(1)=y(3)
           f(2)=y(4)
           f(3)=-y(1)-2*y(1)*y(2)
           f(4)=-y(2)-y(1)**2+y(2)**2
        END IF
        IF (NPROB.EQ.4) THEN
           AK=2.95912208286D-4
	       M(1)=0.000954786104043D0
	       M(2)=0.000285583733151D0
	       M(3)=0.0000437273164546D0
	       M(4)=0.0000517759138449D0
	       M(5)=1.0D0/1.3D8
           M(6)=1.00000597682D0
           DO I=1,5
             I1=3*(I-1)+1
             DO J=I+1,6
	           J1=3*(J-1)+1
	           D(I,J)=(SQRT((Y(I1)-Y(J1))**2+(Y(I1+1)-Y(J1+1))**2+
     *		      (Y(I1+2)-Y(J1+2))**2))**3
	           D(J,I)=D(I,J)
	         END DO
	       END DO
           DO I=1,6
	         I1=3*(I-1)+1
	         F(18+I1)=0.0D0
	         F(18+I1+1)=0.0D0
             F(18+I1+2)=0.0D0
	         DO J=1,6
               IF (J.NE.I) THEN
	             J1=3*(J-1)+1
	             F(18+I1)=F(18+I1)+M(J)*(Y(J1)-Y(I1))/D(I,J)
	             F(18+I1+1)=F(18+I1+1)+M(J)*(Y(J1+1)-Y(I1+1))/D(I,J)
	             F(18+I1+2)=F(18+I1+2)+M(J)*(Y(J1+2)-Y(I1+2))/D(I,J)
               END IF
	         END DO
	         F(18+I1)=AK*F(18+I1)
	         F(18+I1+1)=AK*F(18+I1+1)
	         F(18+I1+2)=AK*F(18+I1+2)
	         F(I1)=Y(18+I1)
	         F(I1+1)=Y(18+I1+1)
	         F(I1+2)=Y(18+I1+2)
           END DO
        END IF
        RETURN
        END 
c
        SUBROUTINE DHAMIL(N,Y,HAM)
        IMPLICIT REAL*8 (A-H,O-Z) 
        DOUBLE PRECISION  D(6,6),M(6)
        DIMENSION Y(N)
        common /COUNT/NFCN,NPROB
          nfcn=nfcn+1
        IF (NPROB.EQ.1) THEN
           HAM=(Y(3)**2+Y(4)**2)/2-1/SQRT(Y(1)**2+Y(2)**2) 
        END IF
        IF (NPROB.EQ.2) THEN
           UPOT=(Y(1)**2+Y(2)**2)/2 + Y(1)**2*Y(2) - Y(2)**3/3
           HAM=(Y(3)**2+Y(4)**2)/2 + UPOT
        END IF
        IF (NPROB.EQ.4) THEN
	       AK=2.95912208286D-4
	       M(1)=0.000954786104043D0
	       M(2)=0.000285583733151D0
	       M(3)=0.0000437273164546D0
           M(4)=0.0000517759138449D0
           M(5)=1.0D0/1.3D8
           M(6)=1.00000597682D0
           DO I=1,5
             I1=3*(I-1)+1
             DO J=I+1,6
               J1=3*(J-1)+1
               D(I,J)=SQRT((Y(I1)-Y(J1))**2+(Y(I1+1)-Y(J1+1))**2+
     *	           (Y(I1+2)-Y(J1+2))**2)
	           D(J,I)=D(I,J)
            END DO
          END DO
          HAM=0.0D0
          DO I=1,6
	        I1=18+3*(I-1)+1
            HAM=HAM+M(I)*(Y(I1)**2+Y(I1+1)**2+Y(I1+2)**2)
          END DO
          HAM=HAM/2
          POT=0.0D0
          DO I=2,6
            DO J=1,I-1
              POT=POT+M(I)*M(J)/D(I,J)
            END DO
          END DO
          HAM=HAM-AK*POT
        END IF
        RETURN
        END 
c
        SUBROUTINE DMOMEN(N,Y,DANG)
        IMPLICIT REAL*8 (A-H,O-Z) 
        REAL*8 Y(N),DANG(3),M(6)
	       M(1)=0.000954786104043D0
	       M(2)=0.000285583733151D0
	       M(3)=0.0000437273164546D0
	       M(4)=0.0000517759138449D0
	       M(5)=1.0D0/1.3D8
           M(6)=1.00000597682D0
        ND2=N/2
        DO ID=1,3
          DANG(ID)=0.0D0
          DO I=1,6
            ID1=MOD(ID,3)+1
            ID2=MOD(ID+1,3)+1
            I1=(I-1)*3+ID1
            I2=(I-1)*3+ID2
            DANG(ID)=DANG(ID)+M(I)*(Y(I1)*Y(ND2+I2)-Y(I2)*Y(ND2+I1))
          END DO
        END DO
        RETURN
        END 
c
        SUBROUTINE CHDATA(N,Y)
        IMPLICIT REAL*8 (A-H,O-Z) 
        REAL*8 Y(N),M(6),VMEAN(3)
	       M(1)=0.000954786104043D0
	       M(2)=0.000285583733151D0
	       M(3)=0.0000437273164546D0
	       M(4)=0.0000517759138449D0
	       M(5)=1.0D0/1.3D8
           M(6)=1.00000597682D0
        AMM=0.0D0
        DO I=1,6
           AMM=AMM+M(I)
        END DO
        ND2=N/2
        DO ID=1,3
          VMEAN(ID)=0.0D0
          DO I=1,6
            I1=(I-1)*3+ID+ND2
            VMEAN(ID)=VMEAN(ID)+M(I)*Y(I1)
          END DO
          VMEAN(ID)=VMEAN(ID)/AMM
          DO I=1,6
            I1=(I-1)*3+ID+ND2
            Y(I1)=Y(I1)-VMEAN(ID)
          END DO
        END DO
        RETURN
        END 
C 
      real function urand(iy)
      integer*4 iy
      integer*4 ia,ic,m2
      parameter(m2=1073741824)
      parameter(ia=843314861)
      parameter(ic=453816693)
   20 iy=iy*ia+ic      
      if(iy.lt.0)then
       iy=(iy+m2)+m2
      endif
      urand=float(iy)*real((.5/m2))
      return
      end
