C
      SUBROUTINE GRKAAD(N,FCN,NSTEP,X,Y,XEND,METH,IOUT,RPAR)
C ----------------------------------------------------------
      PARAMETER (NDGL=50,NSD=15)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION Y(N),YH(NDGL),YCS(NDGL),F(NDGL*NSD),Z(NDGL*NSD)
      DIMENSION RPAR(10),METH(10)
      DIMENSION C(NSD),A(NSD,NSD),AP(NSD,NSD),B(NSD),BP(NSD)
      EXTERNAL FCN
      NS=METH(1)
      NSS=NS*N
      ICOS=METH(2)
      ITSW=METH(3)
      ISYM=METH(4)
      IF (ICOS.NE.0) WRITE (6,*) ' METH(2) = ',ICOS, ' NOT ALLOWED'
      IF (ISYM.NE.0) WRITE (6,*) ' METH(4) = ',ISYM, ' NOT ALLOWED'
      H=(XEND-X)/NSTEP
      CALL GAUSPD(NS,C,B,BP,NSD,A,AP)
      IF (IOUT.NE.0) CALL SOLFID (0,X,X,Y,N,IRTRN)
      DO I=1,N
        YCS(I)=0.0D0
      END DO
C ---
      DO ISTEP=1,NSTEP
        CALL FCN(N,X,Y,F)
        DO I=1,N
          FFS=H*F(I)
          YYI=Y(I)
          DO IS=1,NS
            Z(I+(IS-1)*N)=YYI+C(IS)*FFS
          END DO
        END DO
C
        DYMIN=100.D0
        DYNO=10.D0
        ITER=0
        EPS=RPAR(1)
        IF (ITSW.EQ.0) THEN
          DO WHILE (DYNO.LT.DYMIN.AND.DYNO.NE.0.0D0)
            DYMIN=MIN(DYMIN,DYNO)
            CALL ITAAD(FCN,N,NS,NSS,X,Y,YH,NSD,A,AP,C,NDGL,F,Z,H,DYNO)
          END DO
        ELSE
          DO WHILE (DYNO.GT.EPS.AND.ITER.LE.50)
            ITER=ITER+1
            CALL ITAAD(FCN,N,NS,NSS,X,Y,YH,NSD,A,AP,C,NDGL,F,Z,H,DYNO)
          END DO
          if (iter.ge.49) write (6,*) ' no convergence',iter, dyno
          DO IS=1,NS
            ISN=1+(IS-1)*N
            CALL FCN(N,X+H*C(IS),Z(ISN),F(ISN))
          END DO
        END IF
C
  33    CONTINUE
C        X=X+H
        X=ISTEP*H
        DO I=1,N
          SUMA=0.0D0
          SUME=0.0D0
          DO IS=1,NS/2
            FF=F(I+(IS-1)*N)+F(I+(NS-IS)*N)
            SUMA=SUMA+B(IS)*FF
            SUME=SUME+BP(IS)*FF
          END DO
          IF (2*(NS/2).NE.NS) THEN
            IS=1+NS/2
            FF=F(I+(IS-1)*N)
            SUMA=SUMA+B(IS)*FF
            SUME=SUME+BP(IS)*FF
          END IF
          TEMP=Y(I)
          YCSI=YCS(I)+H*SUMA
          YI=TEMP+YCSI
          YCSI=YCSI+(TEMP-YI)
          YCSI=YCSI+H*SUME
          Y(I)=YI+YCSI
          YCS(I)=YCSI+(YI-Y(I))
        END DO
        IF (IOUT.NE.0) CALL SOLFID (ISTEP,X-H,X,Y,N,IRTRN)
      END DO
      RETURN
      END
C
      SUBROUTINE ITAAD(FCN,N,NS,NSS,X,Y,YH,NSD,A,AP,C,NDGL,F,Z,H,DYNO)
C ----------------------------------------------------------
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION Y(N),YH(NDGL),F(NDGL*NS),Z(NDGL*NS)
      DIMENSION C(NS),A(NSD,NS),AP(NSD,NS)
      EXTERNAL FCN
      DO IS=1,NS
        ISN=1+(IS-1)*N
        CALL FCN(N,X+H*C(IS),Z(ISN),F(ISN))
      END DO
C ---
      DYNO=0.0D0
      DO IS=1,NS
        DO I=1,N
          SUM=0.0D0
          SUMP=0.0D0
          DO JS=NS,1,-1
            FF=F(I+(JS-1)*N)
            SUM=SUM+A(IS,JS)*FF
            SUMP=SUMP+AP(IS,JS)*FF
          END DO
          ISN=I+(IS-1)*N
          ZNEW=Y(I)+H*SUM+H*SUMP
          DYNO=MAX(DYNO,ABS(ZNEW-Z(ISN)))
          Z(ISN)=ZNEW
        END DO
      END DO
      RETURN
      END
C
      SUBROUTINE GAUSPD(NS,C,B,BP,NSD,A,AP)
      PARAMETER (NSDIM=10)
      IMPLICIT DOUBLE PRECISION (A-H,O-P,R-Z)
      IMPLICIT REAL*16 (Q)
      DIMENSION C(NS),B(NS),BP(NS),A(NSD,NS),AP(NSD,NS)
      DIMENSION QC(NSDIM),QB(NSDIM),QA(NSDIM,NSDIM)
      IF (NS.EQ.2) THEN
         B(1)=0.5D0
         A(1,1)= 0.25D0
         A(1,2)=-5.0D0/128.0D0
         A(2,1)= 69.0D0/128.0D0
         A(2,2)= 0.25D0
      END IF
      IF (NS.EQ.3) THEN
         B(1) = 36.0D0/128.0D0
         B(2)=  1.0D0-2*B(1)
         A(1,1) = 18.0D0/128.0D0
         A(1,2) = -5.0D0/128.0D0
         A(1,3) = 1.0D0/128.0D0
         A(2,1) = 38.0D0/128.0D0
         A(2,2) = 28.0D0/128.0D0
         A(2,3) = -3.0D0/128.0D0
         A(3,1) = 34.0D0/128.0D0
         A(3,2) = 61.0D0/128.0D0
         A(3,3) = 18.0D0/128.0D0
      END IF
      IF (NS.EQ.4) THEN
         B(1) = 178.0D0/1024.0D0
         B(2) = 334.0D0/1024.0D0
         A(1,1) = 89.0D0/1024.0D0
         A(1,2) = -27.0D0/1024.0D0
         A(1,3) = 13.0D0/1024.0D0
         A(1,4) = -4.0D0/1024.0D0
         A(2,1) = 193.0D0/1024.0D0
         A(2,2) = 167.0D0/1024.0D0
         A(2,3) = -29.0D0/1024.0D0
         A(2,4) = 7.0D0/1024.0D0
         A(3,1) = 171.0D0/1024.0D0
         A(3,2) = 362.0D0/1024.0D0
         A(3,3) = 167.0D0/1024.0D0
         A(3,4) = -15.0D0/1024.0D0
         A(4,1) = 182.0D0/1024.0D0
         A(4,2) = 321.0D0/1024.0D0
         A(4,3) = 361.0D0/1024.0D0
         A(4,4) = 89.0D0/1024.0D0
      END IF
      IF (NS.EQ.6) THEN
         B(1) = 88.0D0/1024.0D0
         B(2) = 185.0D0/1024.0D0
         B(3) = 239.0D0/1024.0D0
         A(1,1) = 44.0D0/1024.0D0
         A(1,2) = -15.0D0/1024.0D0
         A(1,3) = 10.0D0/1024.0D0
         A(1,4) = -6.0D0/1024.0D0
         A(1,5) = 3.0D0/1024.0D0
         A(1,6) = -1.0D0/1024.0D0
         A(2,1) = 95.0D0/1024.0D0
         A(2,2) = 92.0D0/1024.0D0
         A(2,3) = -21.0D0/1024.0D0
         A(2,4) = 11.0D0/1024.0D0
         A(2,5) = -5.0D0/1024.0D0
         A(2,6) = 1.0D0/1024.0D0
         A(3,1) = 84.0D0/1024.0D0
         A(3,2) = 201.0D0/1024.0D0
         A(3,3) = 120.0D0/1024.0D0
         A(3,4) = -21.0D0/1024.0D0
         A(3,5) = 8.0D0/1024.0D0
         A(3,6) = -2.0D0/1024.0D0
         A(4,1) = 90.0D0/1024.0D0
         A(4,2) = 177.0D0/1024.0D0
         A(4,3) = 261.0D0/1024.0D0
         A(4,4) = 120.0D0/1024.0D0
         A(4,5) = -16.0D0/1024.0D0
         A(4,6) = 3.0D0/1024.0D0
         A(5,1) = 86.0D0/1024.0D0
         A(5,2) = 190.0D0/1024.0D0
         A(5,3) = 229.0D0/1024.0D0
         A(5,4) = 260.0D0/1024.0D0
         A(5,5) = 92.0D0/1024.0D0
         A(5,6) = -7.0D0/1024.0D0
         A(6,1) = 89.0D0/1024.0D0
         A(6,2) = 182.0D0/1024.0D0
         A(6,3) = 245.0D0/1024.0D0
         A(6,4) = 230.0D0/1024.0D0
         A(6,5) = 200.0D0/1024.0D0
         A(6,6) = 44.0D0/1024.0D0
      END IF
      CALL GAUSSQ(NS,QC,QB,NSDIM,QA)
      DO I=1,NS
         C(I)=QC(I)
         BP(I)=QB(I)-B(I)
         DO J=1,NS
            AP(I,J)=QA(I,J)-A(I,J)
         END DO
      END DO
      RETURN
      END
C
      SUBROUTINE GAUSSQ(NS,C,B,NSD,A)
      IMPLICIT REAL*16 (A-H,O-Z)
      DIMENSION C(NS),B(NS),A(NSD,NS)
      IF (NS.EQ.2) THEN
         C(1)=  .211324865405187117745425609749Q+00
         C(2)=  .788675134594812882254574390251Q+00
         B(1) =  0.5Q+00
         A(1,1)=  .250000000000000000000000000000Q+00
         A(1,2)= -.386751345948128822545743902510Q-01
         A(2,1)=  .538675134594812882254574390251Q+00
         A(2,2)=  .250000000000000000000000000000Q+00
      END IF
      IF (NS.EQ.3) THEN
         C(1)=  .112701665379258311482073460022Q+00
         C(2)=  .500000000000000000000000000000Q+00
         C(3)=  .887298334620741688517926539978Q+00
         B(1)=  .277777777777777777777777777778Q+00
         B(2)=  .444444444444444444444444444444Q+00
         A(1,1)=  .138888888888888888888888888889Q+00
         A(1,2)= -.359766675249389034563954710966Q-01
         A(1,3)=  .978944401530832604958004222948Q-02
         A(2,1)=  .300263194980864592438024947213Q+00
         A(2,2)=  .222222222222222222222222222222Q+00
         A(2,3)= -.224854172030868146602471694354Q-01
         A(3,1)=  .267988333762469451728197735548Q+00
         A(3,2)=  .480421111969383347900839915541Q+00
         A(3,3)=  .138888888888888888888888888889Q+00
      END IF
      IF (NS.EQ.4) THEN
         C(1)=  .694318442029737123880267555536Q-01
         C(2)=  .330009478207571867598667120448Q+00
         C(3)=  .669990521792428132401332879552Q+00
         C(4)=  .930568155797026287611973244446Q+00
         B(1) = 0.173927422568726928686531974611Q+00
         B(2) = 0.326072577431273071313468025389Q+00
         A(1,1)=  .869637112843634643432659873055Q-01
         A(1,2)= -.266041800849987933133851304770Q-01
         A(1,3)=  .126274626894047245150568805746Q-01
         A(1,4)= -.355514968579568315691098184957Q-02
         A(2,1)=  .188118117499868071650685545087Q+00
         A(2,2)=  .163036288715636535656734012694Q+00
         A(2,3)= -.278804286024708952241511064190Q-01
         A(2,4)=  .673550059453815551539866908570Q-02
         A(3,1)=  .167191921974188773171133305525Q+00
         A(3,2)=  .353953006033743966537619131808Q+00
         A(3,3)=  .163036288715636535656734012694Q+00
         A(3,4)= -.141906949311411429641535704762Q-01
         A(4,1)=  .177482572254522611843442956461Q+00
         A(4,2)=  .313445114741868346798411144814Q+00
         A(4,3)=  .352676757516271864626853155866Q+00
         A(4,4)=  .869637112843634643432659873055Q-01
      END IF
      IF (NS.EQ.6) THEN
         C(1)=  .337652428984239860938492227530Q-01
         C(2)=  .169395306766867743169300202490Q+00
         C(3)=  .380690406958401545684749139160Q+00
         C(4)=  .619309593041598454315250860840Q+00
         C(5)=  .830604693233132256830699797510Q+00
         C(6)=  .966234757101576013906150777247Q+00
         B(1) = 0.856622461895851725201480710863Q-01
         B(2) = 0.180380786524069303784916756919Q+00
         B(3) = 0.233956967286345523694935171995Q+00
         A(1,1)=  .428311230947925862600740355432Q-01
         A(1,2)= -.147637259971974124753725910605Q-01
         A(1,3)=  .932505070647775119143888450801Q-02
         A(1,4)= -.566885804948351190092125641622Q-02
         A(1,5)=  .285443331509933513092928583012Q-02
         A(1,6)= -.812780171264762112299135651564Q-03
         A(2,1)=  .926734914303788631865122917633Q-01
         A(2,2)=  .901903932620346518924583784594Q-01
         A(2,3)= -.203001022932395859524940805243Q-01
         A(2,4)=  .103631562402464237307199458066Q-01
         A(2,5)= -.488719292803767146341420376580Q-02
         A(2,6)=  .135556105548506177551787075080Q-02
         A(3,1)=  .822479226128438738077716511411Q-01
         A(3,2)=  .196032162333245006055759781564Q+00
         A(3,3)=  .116978483643172761847467585997Q+00
         A(3,4)= -.204825277456560976298590118654Q-01
         A(3,5)=  .798999189966233579720442148033Q-02
         A(3,6)= -.207562578486633419359528915759Q-02
         A(4,1)=  .877378719744515067137433602439Q-01
         A(4,2)=  .172390794624406967987712335439Q+00
         A(4,3)=  .254439495032001621324794183860Q+00
         A(4,4)=  .116978483643172761847467585997Q+00
         A(4,5)= -.156513758091757022708430246450Q-01
         A(4,6)=  .341432357674129871237641994524Q-02
         A(5,1)=  .843066851341001107446302003355Q-01
         A(5,2)=  .185267979452106975248330960685Q+00
         A(5,3)=  .223593811046099099964215226188Q+00
         A(5,4)=  .254257069579585109647429252519Q+00
         A(5,5)=  .901903932620346518924583784593Q-01
         A(5,6)= -.701124524079369066636422067690Q-02
         A(6,1)=  .864750263608499346324472067378Q-01
         A(6,2)=  .177526353208969968653987471089Q+00
         A(6,3)=  .239625825335829035595856428410Q+00
         A(6,4)=  .224631916579867772503496287487Q+00
         A(6,5)=  .195144512521266716260289347979Q+00
         A(6,6)=  .428311230947925862600740355433Q-01
      END IF
      RETURN
      END
C
