function a =tensor_a(x, y)
%TENSOR_A   Evaluate conductivity tensor A
%   A = TENSOR_A(X,Y) returns function values at a discrete point given by
%   X on the macro and Y on the micro domain (see article for details).
%   This input data has to be chosen by the user. 
%   X has dimension 1 x 2 and Y has dimension 1 x 2. A is a 2 x 2 matrix.
%
%   See also HMMFEM2D, F, and G.
%
%
%   The code is available at http://anmc.epfl.ch/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   http://dx.doi.org/10.1016/j.cma.2009.03.019
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


aa= (1.5+sin(2*pi*y(1)))/(1.5+sin(2*pi*y(2))) + ...
    (1.5+sin(2*pi*y(2)))/(1.5+cos(2*pi*y(1))) + ...
    sin(4*x(1)*x(2)) + 1;

a= eye(2).*aa;


end