function a =tensor_a_nonlin(u, x, y)
%TENSOR_A   Evaluate conductivity tensor A
%   A = TENSOR_A(X,Y) returns function values at a discrete point given by
%   X on the macro and Y on the micro domain (see article for details).
%   This input data has to be chosen by the user. 
%   X has dimension 1 x 2 and Y has dimension 1 x 2. A is a 2 x 2 matrix.
%
%   See also HMMFEM2D, F, and G.
%
%
%   The code is available at http://iacs.epfl.ch/anmc/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   Vol. XXXXXXX, p. XXXXXXX
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

yyy1=2+sin(2*pi*y(:,1));
yyy2=2+sin(2*pi*y(:,2));
 a=[yyy1*(1+x(1)*sin(pi*u))/sqrt(3.), zeros(size(y,1),1); ...
    zeros(size(y,1),1), yyy2*(2+atan(u))/sqrt(3.)];

end
